package com.blt.other.other_cost.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_commons.utils.PathUtil;
import com.blt.other.other_cost.service.CostPlanService;
import com.blt.other.other_cost.service.UserCostFinansysService;
import com.blt.other.other_cost.utils.CostFileUtil;
import com.blt.other.other_cost.utils.CostPlanUtils;
import com.blt.other.other_database.model.CostPlanDomain;
import com.blt.other.other_database.model.UserCostFinansysDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/cost/plan/new")
public class CostPlanNewController {

    @Autowired
    private CostPlanService costPlanService;

    @Autowired
    private UserCostFinansysService userCostFinansysService;

    @GetMapping("/getNo")
    public Map<String, Object> getNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);

        String no = costPlanService.createNo();
        Map<String, Object> result = new HashMap<>();
        result.put("costPlanNo", no);
        result.put("success", true);
        return result;
    }

    @PostMapping("/affirm")
    public Map<String,Object> affirm(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();
        String costPlanNo = request.getParameter("costPlanNo");

        Integer affirm = costPlanService.affirm(costPlanNo);

        if (null != affirm && affirm >= 0) {
            result.put("success",true);
            result.put("msg","已生成 "+affirm+" 张付款费用单");
        }else {
            result.put("success", false);
            result.put("msg", "付款计划不存在或发生其他错误");
        }
        return result;
    }

    @PostMapping("/deleted")
    public Map<String,Object> deleted(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String costPlanNo = request.getParameter("costPlanNo");
        Integer deleted = costPlanService.deleted(costPlanNo);
        if (null != deleted && deleted >= 1){
            result.put("success",true);
        }else {
            result.put("success",false);
            result.put("msg","发生错误");
        }
        return result;
    }

    @PostMapping("/resetNoFile")
    public Map<String, Object> resetNoFile(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String costPlanNo = request.getParameter("costPlanNo");
        CostPlanDomain planDomain = CostPlanUtils.createCostPlan(request,costPlanNo);

        // 保存财务信息
//        if (3 == planDomain.getCostForm() && 1 == planDomain.getIsLend()){
//            Integer finansyRecord = doSaveFinansyRecord(planDomain);
//        }
        Integer finansyRecord = doSaveFinansyRecord(planDomain);
        Integer save = costPlanService.update(planDomain);
        if (null != save && save >= 1){
            Map<String,Object> result = new HashMap<>();
            result.put("success",true);
            result.put("msg","已修改");

            return result;
        }
        return null;
    }

    @PostMapping("/resetFile")
    public Map<String, Object> resetFile(HttpServletResponse response, HttpServletRequest request,@RequestParam("fileSelect") MultipartFile file) {
        AxiosUtil.setCors(response, request);
        String costPlanNo = request.getParameter("costPlanNo");
        CostPlanDomain planDomain = CostPlanUtils.createCostPlan(request,costPlanNo);

        // 保存财务信息
//        if (3 == planDomain.getCostForm() && 1 == planDomain.getIsLend()){
//            Integer finansyRecord = doSaveFinansyRecord(planDomain);
//        }
        Integer finansyRecord = doSaveFinansyRecord(planDomain);
        // 文件上传的路径
        String filePath = PathUtil.getBasePath()+PathUtil.getPath("cost/"+planDomain.getCostPlanNo()+"/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(file, filePath);
        planDomain.setFilePath(path);
        Integer save = costPlanService.update(planDomain);
        if (null != save && save >= 1){
            Map<String,Object> result = new HashMap<>();
            result.put("msg","已修改");
            result.put("success",true);
            return result;
        }

        return null;
    }

    /**
     * 保存填写的财务信息
     * @return
     */
    private Integer doSaveFinansyRecord(CostPlanDomain planDomain){
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostPlanDomain(planDomain);
        Integer integer = userCostFinansysService.saveFinansysRecord(finansyRecordByCostDomain);
        return integer;
    }
}
