package com.blt.other.other_purchasing.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_database.model.BuyDomain;
import com.blt.other.other_purchasing.dto.BuyListDto;
import com.blt.other.other_purchasing.service.BuyLogService;
import com.blt.other.other_purchasing.service.BuyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * 采购单列表详情页，操作采购单状态控制器
 * 1、提交财务审核
 */
@RestController
@RequestMapping("/purchasing/list/detail/button")
public class PurchasingListDetailButtonController {

    @Autowired
    private BuyService buyService;
    @Autowired
    private BuyLogService buyLogService;

    /**
     * 采购单提交财务审核
     * @param response
     * @param request
     * @return
     */
    @GetMapping("/pushToAudit")
    public Map<String,Object> pushToAudit(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = null;
        String buyno = request.getParameter("buyno");
        String useridStr = request.getParameter("userid");
        BuyDomain buyDomain = new BuyDomain();
        buyDomain.setBuyno(buyno);
        buyDomain.setBuystatus(2);
        Integer update = buyService.getUpdate(buyDomain);
        if (null != update && update == 1){
            String updateNote = "提交财务审核";
            Integer save = buyLogService.save(buyno, Integer.parseInt(useridStr), updateNote);
            result = new HashMap<>();
            result.put("success",true);
            result.put("msg","采购单已提交财务审核");
        } else {
            result = new HashMap<>();
            result.put("success",false);
            result.put("msg","操作失败，请稍后重试");
        }

        return result;
    }

    /**
     * 财务审核驳回采购单
     * @param response
     * @param request
     * @return
     */
    @GetMapping("/rejectBuy")
    public Map<String,Object> rejectBuy(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = null;
        String buyno = request.getParameter("buyno");
        String useridStr = request.getParameter("userid");
        String rejectReason = request.getParameter("rejectReason");
//        System.out.println(buyno+"  "+useridStr+"  "+rejectReason);
        BuyDomain buyDomain = new BuyDomain();
        buyDomain.setBuyno(buyno);
        buyDomain.setBuystatus(1);
        buyDomain.setRejectReason(rejectReason);
        Integer update = buyService.getUpdate(buyDomain);
        if (null != update && update == 1){
            String updateNote = "财务审核驳回：";
            Integer save = buyLogService.save(buyno, Integer.parseInt(useridStr), updateNote + rejectReason);
            result = new HashMap<>();
            result.put("success",true);
            result.put("msg","采购单已驳回");
        } else {
            result = new HashMap<>();
            result.put("success",false);
            result.put("msg","操作失败，请稍后重试");
        }

        return result;
    }
}
