package com.blt.other.module.cost.service.impl.costtemplate;

import com.bailuntec.common.BeanUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.module.cost.dao.CostTemplateBaseColMapper;
import com.blt.other.module.cost.dto.CostTemplateColReq;
import com.blt.other.module.cost.model.CostTemplateBaseCol;
import com.blt.other.module.cost.service.ICostTemplateBaseColService;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 费用单基础字段 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Service
public class CostTemplateBaseColServiceImpl extends ServiceImpl<CostTemplateBaseColMapper, CostTemplateBaseCol> implements ICostTemplateBaseColService {

    @Override
    public List<CostTemplateBaseCol> listAll() {
        return this.list();
    }

    @Override
    public void add(CostTemplateColReq.AddReq req) {
        if (!req.getIsExtension()) {
            throw new RuntimeException("只能添加扩展字段");
        }
        CostTemplateBaseCol costTemplateBaseCol = new CostTemplateBaseCol();
        BeanUtils.copyProperties(req, costTemplateBaseCol);
        this.save(costTemplateBaseCol);
    }

    @Override
    public void modify(CostTemplateBaseCol costTemplateBaseCol) {
        this.updateById(costTemplateBaseCol);
    }

    @Override
    public void delete(@NonNull Integer id) {
        this.removeById(id);
    }

    @Override
    public List<CostTemplateBaseCol> defaultBaseColList(@NonNull Integer costFrom) {
        return baseMapper.defaultBaseColList(costFrom);
    }
}
