package com.blt.other.module.cost.controller.costtemplate;


import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.module.cost.dto.CostTemplateApiDto;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.cost.service.ICostTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 费用单模版 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Api(tags = "费用单模版接口")
@RestController
@RequestMapping("/costTemplate")
public class CostTemplateController {

    @Resource
    ICostTemplateService costTemplateService;

    @ApiOperation("添加费用单模版")
    @PostMapping("/add")
    public CostResult<Void> add(@RequestBody CostTemplate costTemplate) {
        costTemplateService.add(costTemplate);
        return CostResult.success();
    }

    @ApiOperation("更新费用单模版")
    @PostMapping("/edit")
    public CostResult<Void> update(@RequestBody CostTemplate costTemplate) {
        costTemplateService.edit(costTemplate);
        return CostResult.success();
    }

    @ApiOperation("/查询费用单模板")
    @GetMapping("/queryDetail")
    public CostResult<CostTemplate> queryDetail(@RequestParam Integer id) {
        CostTemplate costTemplate = costTemplateService.queryDetail(id);
        return CostResult.success(costTemplate);
    }

    @ApiOperation("/查询费用单模板")
    @GetMapping("/queryList")
    public CostResult<List<CostTemplate>> queryList(CostTemplateApiDto.QueryListReq req) {
        List<CostTemplate> costTemplateList = costTemplateService.queryList(req);
        return CostResult.success(costTemplateList);
    }


    @ApiOperation("删除费用单模版")
    @GetMapping("/delete")
    public CostResult<Void> delete(@RequestParam Integer id) {
        costTemplateService.delete(id);
        return CostResult.success();
    }

}

