package com.blt.other.other_cost.service.impl;

import com.blt.other.other_auth.dao.UserDao;
import com.blt.other.other_commons.utils.CurUtils;
import com.blt.other.other_cost.dao.*;
import com.blt.other.other_cost.dto.CostPlanDto;
import com.blt.other.other_cost.service.CostLogService;
import com.blt.other.other_cost.service.CostPlanService;
import com.blt.other.other_cost.service.CostPlanTempService;
import com.blt.other.other_cost.service.CostService;
import com.blt.other.other_cost.utils.CostUtils;
import com.blt.other.other_database.mapper.StatusMapper;
import com.blt.other.other_database.model.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class CostPlanServiceImpl implements CostPlanService {

    private Logger logger = LoggerFactory.getLogger(CostPlanServiceImpl.class);

    @Autowired
    private CostPlanDao costPlanDao;
    @Autowired
    private CostPlanTempDao costPlanTempDao;
    @Autowired
    private CostPlanTempService costPlanTempService;
    @Autowired
    private CostTypeKindDao costTypeKindDao;
    @Autowired
    private CostCompanyDao costCompanyDao;
    @Autowired
    private StatusMapper statusMapper;
    @Autowired
    private UserDao userDao;
    @Autowired
    private CostDao costDao;
    @Autowired
    private CostDetailDao costDetailDao;
    @Autowired
    private CostPlanService costPlanService;
    @Autowired
    private CostLogService costLogService;
    @Autowired
    private CostService costService;
    @Autowired
    private CostTypeDao costTypeDao;

    @Value("${url.api.getExchangeRateApi}")
    private String getExchangeRateApi;

    @Override
    public String createNo() {

        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddhhmmss");
        String no = "CP" + sdf.format(new Date()) + random.nextInt(9);
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(no);
        while (null != costPlanDomain && null != costPlanDomain.getCostPlanNo()) {
            no = "CP" + sdf.format(new Date()) + random.nextInt(9);
            costPlanDomain = costPlanDao.selectByNo(no);
        }
        return no;
    }

    /**
     * 保存费用计划
     *
     * @param planDomain
     * @return
     */
    @Override
    public Integer save(CostPlanDomain planDomain) {
        CostPlanDomain plan = null;
        if (1 == planDomain.getCostForm()) {
            plan = setPayDomain(planDomain);
        }
        if (2 == planDomain.getCostForm()) {
            plan = setReceiptDomain(planDomain);
        }
        if (3 == planDomain.getCostForm()) {
            // 保存借支单,借还单
            plan = setLend(planDomain);
        }
        if (null != plan) {
            plan.setCostPlanStatus(0);
            return costPlanDao.insert(plan);
        }
        return null;
    }

    private CostPlanDomain setLend(CostPlanDomain planDomain) {
        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(planDomain.getKindNo());
        planDomain.setTypeNo(costTypeKindDomain.getTypeNo());
        planDomain.setTypeName(costTypeKindDomain.getTypeName());
        planDomain.setKindName(costTypeKindDomain.getKindName());
        planDomain.setCompanyName(costTypeKindDomain.getCompanyName());
        UserDomain user = userDao.select(planDomain.getCreateUsercode());
        planDomain.setCreateUserid(user.getUserid());
        planDomain.setCreateUsername(user.getUsername());
        if (1 == planDomain.getIsLend()) {
        }
        if (2 == planDomain.getIsLend()) {
        }
        return planDomain;
    }

    private CostPlanDomain setReceiptDomain(CostPlanDomain planDomain) {
        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(planDomain.getKindNo());
        planDomain.setTypeNo(costTypeKindDomain.getTypeNo());
        planDomain.setTypeName(costTypeKindDomain.getTypeName());
        planDomain.setKindName(costTypeKindDomain.getKindName());
        planDomain.setCompanyName(costTypeKindDomain.getCompanyName());

        UserDomain user = userDao.select(planDomain.getCreateUsercode());
        planDomain.setCreateUserid(user.getUserid());
        planDomain.setCreateUsername(user.getUsername());

        return planDomain;
    }

    @Override
    public Integer update(CostPlanDomain planDomain) {
        CostPlanDomain plan = null;
        if (1 == planDomain.getCostForm()) {
            plan = setPayDomain(planDomain);
        }
        if (2 == planDomain.getCostForm()) {
            plan = setReceiptDomain(planDomain);
        }
        if (3 == planDomain.getCostForm()) {
            plan = setLend(planDomain);
        }
        Integer update = costPlanDao.update(plan);
        return update;
    }

    @Override
    public Integer affirm(String costPlanNo) {
        Map<String, Object> map = new HashMap<>();
        // 获取 costPlan
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);
        if (null == costPlanDomain || null == costPlanDomain.getCostForm()) {
            return null;
        } else {
            Integer result = null;
            if (1 == costPlanDomain.getCostForm()) {
                result = affirmPay(costPlanNo);
            } else {
                result = affirmNoPay(costPlanDomain);
            }
            // 改变计划单状态
            if (null != result && result > 0) {
                costPlanDomain.setCostPlanStatus(1);
                costPlanDao.update(costPlanDomain);
            }
            return result;
        }
    }

    /**
     * 生成 costNo
     *
     * @return
     */
    private String getCostNo() {
        String costNo = CostUtils.getIdNum(costService);
        CostDomain costByNo = costDao.selectByCostNo(costNo);
        while (null != costByNo && null != costByNo.getId()) {
            costNo = CostUtils.getIdNum(costService);
        }
        return costNo;
    }

    private Integer affirmNoPay(CostPlanDomain costPlanDomain) {
        if (null != costPlanDomain && (3 == costPlanDomain.getCostForm() && 2 == costPlanDomain.getIsLend())) {
            // 借还单确认时，根据借支单金额、冲销金额、余额拆单
            Integer result = splitLend(costPlanDomain);
            return result;
        } else {
            CostDomain costDomain = planToCost(costPlanDomain.getCostPlanNo());
            String costNo = getCostNo();
            costDomain.setCostNo(costNo);
            costDomain.setCostStatus(0);
            costDomain.setAmount(costPlanDomain.getPlanAmount());
            BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY", getExchangeRateApi);
            costDomain.setToRmbRate(toRmbRate);
            costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
//        costDomain.setCostPlanNo(costPlanDomain);
            Integer insert = costDao.insert(costDomain);
            if (null == insert || insert <= 0) {
                return 0;
            }
            if (2 == costDomain.getCostForm()){
                // 记录日志
                costLogService.save(costDomain.getCostNo(),costDomain.getCreateUserid(),
                        "由费用计划："+costDomain.getCostPlanNo()+" 生成收款单");
            }else {
                // 记录日志
                costLogService.save(costDomain.getCostNo(),costDomain.getCreateUserid(),
                        "由费用计划："+costDomain.getCostPlanNo()+" 生成借支单");
            }
            return insert;
        }
    }

    /**
     * 借还单确认时，根据借支单金额、冲销金额、余额拆单
     *
     * @param costPlanDomain 借还计划
     * @return 生成的费用单数
     */
    private Integer splitLend(CostPlanDomain costPlanDomain) {
        if (null != costPlanDomain && null == costPlanDomain.getIsTax()) {
            costPlanDomain.setIsTax(0);
        }
        CostDomain supCost = costDao.selectByCostNo(costPlanDomain.getSupCostNo());
        // 关联借支单还需还差额 subtract
        if (null == supCost.getHadPay()) supCost.setHadPay(new BigDecimal(0));
        if (null == supCost.getCounteract()) supCost.setCounteract(new BigDecimal(0));
        if (null == supCost.getLendBalance()) supCost.setLendBalance(new BigDecimal(0));
        BigDecimal subtract = supCost.getAmount().subtract(supCost.getHadPay());
        BigDecimal counteract = costPlanDomain.getCounteract();
        BigDecimal lendBalance = costPlanDomain.getLendBalance();
        BigDecimal numZero = new BigDecimal(0);

        Integer result = 0;
        if (counteract.compareTo(numZero) == 0 && lendBalance.compareTo(numZero) == 1) {
            // 1、冲销 0，还 大于0 ==== 生成一张收款的借还单
            CostDomain costDomain = planToCost(costPlanDomain.getCostPlanNo());
            costDomain.setCostNo(getCostNo());
            costDomain.setCostStatus(0);
            costDomain.setAmount(costPlanDomain.getPlanAmount());
            BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY", getExchangeRateApi);
            costDomain.setToRmbRate(toRmbRate);
            costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
            Integer insert = costDao.insert(costDomain);
            if (null != insert && insert == 1) {
                logger.info("1、冲销 0，还 大于0 ==== 生成一张收款的借还单: " + costDomain);
                // 记录日志
                costLogService.save(costDomain.getCostNo(),costDomain.getCreateUserid(),
                        "由费用计划："+costDomain.getCostPlanNo()+" 生成收款借还单");
                result = 1;
            } else {
                logger.error("1、冲销 0，还 大于0 ==== 生成一张收款的借还单失败: " + costDomain);
            }
        } else if (counteract.compareTo(numZero) == 1 && lendBalance.compareTo(numZero) == 0) {
            // 2、冲销 大于 0，还 0
            if (counteract.compareTo(subtract) == 0 || counteract.compareTo(subtract) == -1) {
                // 2.1、冲销刚好抵消差额 / 冲销小于差额  ===== 生成一张无需付款的借还单
                CostDomain costDomain = planToCost(costPlanDomain.getCostPlanNo());
                costDomain.setCostNo(getCostNo());
                costDomain.setCostStatus(0);
                costDomain.setAmount(costPlanDomain.getPlanAmount());
                BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY", getExchangeRateApi);
                costDomain.setToRmbRate(toRmbRate);
                costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
                Integer insert = costDao.insert(costDomain);
                if (null != insert && insert == 1) {
                    logger.info("2.1、冲销刚好抵消差额 / 冲销小于差额  ===== 生成一张无需付款的借还单：" + costDomain);
                    // 记录日志
                    costLogService.save(costDomain.getCostNo(),costDomain.getCreateUserid(),
                            "由费用计划："+costDomain.getCostPlanNo()+" 生成冲销单");
                    result = 1;
                } else {
                    logger.info("2.1、冲销刚好抵消差额 / 冲销小于差额  ===== 生成一张无需付款的借还单失败：" + costDomain);
                }
            } else {
                // 2.2、冲销大于差额  ===== 生成一张无需收款的借还单 + 一张付款单（出纳回调接口和财务审核接口改为借还出纳回调接口，费用单号以 “S” 打头）
                logger.info("2.2、冲销大于差额  ===== 准备生成一张无需收款的借还单 + 一张付款单（出纳回调接口和财务审核接口改为借还出纳回调接口，费用单号以 “S” 打头）");
                CostDomain costDomain1 = planToCost(costPlanDomain.getCostPlanNo());
                costDomain1.setCostNo(getCostNo());
                costDomain1.setCostStatus(0);
                costDomain1.setAmount(subtract);
                costDomain1.setCounteract(subtract);
                costDomain1.setPayPlanAmount(subtract.divide(costPlanDomain.getPayCur(), 4));
                costDomain1.setPayCounteract(subtract.divide(costPlanDomain.getPayCur(), 4));
                BigDecimal toRmbRate = CurUtils.getCur(costDomain1.getDic(), "CNY", getExchangeRateApi);
                costDomain1.setToRmbRate(toRmbRate);
                costDomain1.setAmountRmb(costDomain1.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
                Integer insert1 = costDao.insert(costDomain1);
                if (null != insert1 && insert1 == 1) {
                    logger.info("生成一张无需收款的借还单：" + costDomain1);
                    // 记录日志
                    costLogService.save(costDomain1.getCostNo(),costDomain1.getCreateUserid(),
                            "由费用计划："+costDomain1.getCostPlanNo()+" 生成冲销单");
                } else {
                    logger.info("生成一张无需收款的借还单失败：" + costDomain1);
                }
                result = result + insert1;

                /**
                 *  改为生成一张待提交的付款计划   且必须选择付款子项后才能确认（前端判断costTemps，后端判断是否有子项目）
                 *  差额计划单生成付款费用单时，费用单号保留 S 打头
                 *  差额计划单的总额、创建一个空的子项目，但是不选类型
                 *  前端 costForm = 1  isLend = 2 时，不可以删除自动生成的空的子项目，只能修改（后端删除子项目的环节同样需要判断）
                 */
                CostPlanDomain payPlan = new CostPlanDomain();
                BeanUtils.copyProperties(costPlanDomain,payPlan);
                BigDecimal compensate = costPlanDomain.getCounteract().subtract(subtract);
                payPlan.setCostPlanNo("S"+costPlanService.createNo());
                payPlan.setCostPlanStatus(0);
                payPlan.setCostForm(1);
                payPlan.setIsLend(2);
                payPlan.setPlanAmount(compensate);
                payPlan.setPayPlanAmount(compensate.divide(costPlanDomain.getPayCur(), 4));
                payPlan.setCounteract(new BigDecimal(0));
                payPlan.setPayCounteract(new BigDecimal(0));
                payPlan.setIsTax(0);
                payPlan.setTypeNo(null);
                payPlan.setTypeName(null);
                payPlan.setKindName(null);
                payPlan.setKindNo(null);
                payPlan.setCostReason("借支差额："+payPlan.getSupCostNo());
                Integer insert2 = costPlanDao.insert(payPlan);
                if (null != insert2 && insert2 == 1) {
                    logger.info("生成一张补差额的付款单计划：" + payPlan);
                    // 生成空子类的子项目
                    CostPlanTempDomain temp = new CostPlanTempDomain();
                    temp.setTempNo(costPlanTempService.createNo());
                    temp.setCostPlanNo(payPlan.getCostPlanNo());
                    temp.setCostReason("借支差额："+payPlan.getSupCostNo());
                    temp.setAmount(payPlan.getPlanAmount());
                    temp.setDic(payPlan.getDic());
                    Integer insert = costPlanTempDao.insert(temp);
                    if (null != insert && insert == 1) {
                        logger.info("生成差额单子项目 "+temp);
                    }
                    // 借支单的补差额添加金额
                    if (null == supCost.getCompensate()) {
                        supCost.setCompensate(new BigDecimal(0));
                    }
                    supCost.setCompensate(supCost.getCompensate().add(payPlan.getPlanAmount()));
                    costDao.update(supCost);

                } else {
                    logger.info("生成一张补差额的付款单失败：" + costDomain1);
                }
//                result = result + insert2;
            }
        } else if (counteract.compareTo(numZero) == 1 && lendBalance.compareTo(numZero) == 1) {
            // 3、冲销 大于 0，还 大于0 生成一张无需付款的借还单，一张收款的借还单
            logger.info("3、冲销 大于 0，还 大于0 ，准备生成一张无需付款的借还单，一张收款的借还单");
            CostDomain costDomain1 = planToCost(costPlanDomain.getCostPlanNo());
            costDomain1.setCostNo(getCostNo());
            costDomain1.setCostStatus(0);
            costDomain1.setAmount(costDomain1.getCounteract());
            costDomain1.setLendBalance(new BigDecimal(0));
            costDomain1.setPayPlanAmount(costDomain1.getPayCounteract());
            costDomain1.setPayLendBalance(new BigDecimal(0));
            BigDecimal toRmbRate = CurUtils.getCur(costDomain1.getDic(), "CNY", getExchangeRateApi);
            costDomain1.setToRmbRate(toRmbRate);
            costDomain1.setAmountRmb(costDomain1.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
            Integer insert1 = costDao.insert(costDomain1);
            if (null != insert1 && insert1 == 1) {
                logger.info("生成一张无需付款的借还单：" + costDomain1);
                costLogService.save(costDomain1.getCostNo(),costDomain1.getCreateUserid(),
                        "由费用计划："+costDomain1.getCostPlanNo()+" 生成冲销单");
            } else {
                logger.info("生成一张无需付款的借还单失败：" + costDomain1);
            }
            result = result + insert1;

            CostDomain costDomain2 = planToCost(costPlanDomain.getCostPlanNo());
            costDomain2.setCostNo(getCostNo());
            costDomain2.setCostStatus(0);
            costDomain2.setAmount(costDomain2.getLendBalance());
            costDomain2.setCounteract(new BigDecimal(0));
            costDomain2.setPayPlanAmount(costDomain2.getPayLendBalance());
            costDomain2.setPayCounteract(new BigDecimal(0));
            BigDecimal toRmbRate1 = CurUtils.getCur(costDomain2.getDic(), "CNY", getExchangeRateApi);
            costDomain2.setToRmbRate(toRmbRate1);
            costDomain2.setAmountRmb(costDomain2.getAmount().multiply(toRmbRate1).setScale(2, BigDecimal.ROUND_HALF_UP));
            Integer insert2 = costDao.insert(costDomain2);
            if (null != insert2 && insert2 == 1) {
                logger.info("生成一张收款的借还单：" + costDomain2);
                costLogService.save(costDomain2.getCostNo(),costDomain2.getCreateUserid(),
                        "由费用计划："+costDomain2.getCostPlanNo()+" 生成收款借还单");
            } else {
                logger.info("生成一张收款的借还单：" + costDomain2);
            }
            result = result + insert2;
        }
        return result;
    }

    private Integer affirmPay(String costPlanNo) {
        // 获取 temp 表中的记录
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);
        List<CostPlanTempDomain> costPlanTempDomains = costPlanTempDao.selectListByPlanNo(costPlanNo);

        // =================================================================================
        if (null == costPlanDomain || null == costPlanDomain.getId()) {
            return null;
        } else {
            if (null == costPlanTempDomains || costPlanTempDomains.size() == 0) {
                return 0;
            } else {
                boolean nullKindItem = false;
                for(CostPlanTempDomain temp : costPlanTempDomains){
                    if (null == temp.getTypeNo() || null == temp.getKindNo()) {
                        nullKindItem = true;
                    }
                }
                if (nullKindItem) {
                    // 存在有金额、但是没有选择类型的子项目，同样返回 0
                    return 0;
                } else {
                    // 将 List<CostPlanTempDomain> 转为 List<CostDetailDomain>
                    List<CostDetailDomain> detailList = new ArrayList<>();
                    Integer index = 1;
                    for (CostPlanTempDomain costPlanTempDomain : costPlanTempDomains) {
                        CostDetailDomain costDetailDomain = tempToDetail(costPlanTempDomain, costPlanDomain, index);

                        detailList.add(costDetailDomain);
                        index += 1;
                    }
                    // 根据大类分类
                    Map<String, List<CostDetailDomain>> detailMap = new HashMap<>();
                    for (CostDetailDomain costDetailDomain : detailList) {
                        List<CostDetailDomain> costDetailDomains = detailMap.get(costDetailDomain.getTypeNo());
                        if (null == costDetailDomains) {
                            costDetailDomains = new ArrayList<>();
                            costDetailDomains.add(costDetailDomain);
                            detailMap.put(costDetailDomain.getTypeNo(), costDetailDomains);
                        } else {
                            costDetailDomains.add(costDetailDomain);
                            detailMap.put(costDetailDomain.getTypeNo(), costDetailDomains);
                        }
                    }
                    // 按照不同的大类生成付款费用单、费用详情
                    Set<String> strings = detailMap.keySet();
                    Integer result = 0;
                    for (String typeNo : strings) {
                        List<CostDetailDomain> costDetailDomains = detailMap.get(typeNo);
                        // 生成付款费用单
                        CostDomain costDomain = planToCost(costPlanNo);
                        String costNo = CostUtils.getIdNum(costService);
                        // 差额单（冲销借支单自动生成的补差额的付款费用）的单号以 “S” 打头
                        if (costPlanNo.startsWith("S")) {
                            costNo = "S" + costNo;
                        }
                        CostDomain costByNo = costDao.selectByCostNo(costNo);
                        while (null != costByNo && null != costByNo.getId()) {
                            costNo = CostUtils.getIdNum(costService);
                            if (costPlanNo.startsWith("S")) {
                                costNo = "S" + costNo;
                            }
                            costByNo = costDao.selectByCostNo(costNo);
                        }
                        costDomain.setCostNo(costNo);
                        costDomain.setTypeNo(typeNo);
                        costDomain.setTypeName(costDetailDomains.get(0).getTypeName());
                        CostTypeDomain costTypeDomain = costTypeDao.selectByTypeNo(typeNo);
                        costDomain.setSubjectCode(costTypeDomain.getSubjectCode());
                        String kindSuffix = "";
                        if (costDetailDomains.size() > 1) {
                            kindSuffix = " 等共" + costDetailDomains.size() + "项";
                        }
                        costDomain.setKindNo(costDetailDomains.get(0).getKindNo() + kindSuffix);
                        costDomain.setKindName(costDetailDomains.get(0).getKindName() + kindSuffix);
                        if (null == costDomain.getAmount()) {
                            costDomain.setAmount(new BigDecimal(0));
                        }
                        for (CostDetailDomain costDetailDomain : costDetailDomains) {
                            costDomain.setAmount(costDomain.getAmount().add(costDetailDomain.getAmount()));
                        }
                        costDomain.setDic(costDetailDomains.get(0).getDic());
                        costDomain.setCostStatus(0);
                        BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY", getExchangeRateApi);
                        costDomain.setToRmbRate(toRmbRate);
                        costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));

                        // 生成付款费用详情单
                        try {
                            for (CostDetailDomain costDetailDomain : costDetailDomains) {
                                costDetailDomain.setCostNo(costNo);
                                // 生成付款费用详情
                                costDetailDao.insert(costDetailDomain);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                            return null;
                        }
                        // 执行添加记录流程
                        costDomain.setCostPlanNo(costPlanNo);
                        Integer insert = costDao.insert(costDomain);
                        if (null != insert && insert >= 1) {
                            // 记录日志
                            costLogService.save(costDomain.getCostNo(),costDomain.getCreateUserid(),
                                    "由费用计划："+costDomain.getCostPlanNo()+" 生成付款单");
                            result += insert;
                        }
                    }
                    return result;
                }
            }
            // else 闭合
        }
    }

    @Override
    public Integer deleted(String costPlanNo) {
        Integer result = costPlanDao.deleted(costPlanNo);
        return result;
    }

    @Override
    public List<CostPlanDomain> getAllCostList() {
        List<CostPlanDomain> costPlanDomains = costPlanDao.selectAll();
        return costPlanDomains;
    }

    @Override
    public List<CostPlanDto> domainListToDtoList(List<CostPlanDomain> costPlanDomains) {
        List<CostPlanDto> list = null;
        if (null != costPlanDomains && costPlanDomains.size() >= 1) {
            list = new ArrayList<>();
            for (CostPlanDomain costPlanDomain : costPlanDomains) {
                CostPlanDto costPlanDto = new CostPlanDto();
                BeanUtils.copyProperties(costPlanDomain, costPlanDto);
                costPlanDto.setCostFormDto(statusMapper.getStatusValue("cost_form", costPlanDto.getCostForm()));
                costPlanDto.setIsLendDto(statusMapper.getStatusValue("is_lend", costPlanDto.getIsLend()));
                costPlanDto.setCostPlanStatusDto(statusMapper.getStatusValue("cost_plan_status", costPlanDto.getCostPlanStatus()));
                if (1 == costPlanDto.getCostForm()) {
                    costPlanDto.setIsTaxStr(statusMapper.getStatusValue("is_tax", costPlanDto.getIsTax()));
                } else {
                    costPlanDto.setIsTaxStr("");
                }

                list.add(costPlanDto);
            }
        }
        return list;
    }

    @Override
    public CostPlanDomain getByPlanNo(String planNo) {
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(planNo);
        if (null != costPlanDomain && null != costPlanDomain.getCostPlanNo()) {
            return costPlanDomain;
        }
        return null;
    }

    private CostDomain planToCost(String costPlanNo) {
        CostDomain costDomain = new CostDomain();
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);
        BeanUtils.copyProperties(costPlanDomain, costDomain);
        costDomain.setCompanyValue(costCompanyDao.selectByNo(costPlanDomain.getCompanyNo()).getValue());
        if(costDomain.getTypeNo() != null){
            CostTypeDomain costTypeDomain = costTypeDao.selectByTypeNo(costDomain.getTypeNo());
            if(costTypeDomain != null){
                costDomain.setSubjectCode(costTypeDomain.getSubjectCode());
            }
        }
        return costDomain;
    }

    private CostDetailDomain tempToDetail(CostPlanTempDomain costPlanTempDomain, CostPlanDomain costPlanDomain, Integer index) {
        CostDetailDomain costDetailDomain = new CostDetailDomain();
        BeanUtils.copyProperties(costPlanDomain, costDetailDomain);
        BeanUtils.copyProperties(costPlanTempDomain, costDetailDomain);
        costDetailDomain.setDetailNo(costPlanDomain.getCostPlanNo() + "-" + index);

        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(costPlanTempDomain.getKindNo());
        costDetailDomain.setKindName(costTypeKindDomain.getKindName());
        costDetailDomain.setTypeNo(costTypeKindDomain.getTypeNo());
        costDetailDomain.setTypeName(costTypeKindDomain.getTypeName());
        return costDetailDomain;
    }

    private CostPlanDomain setPayDomain(CostPlanDomain planDomain) {
        CostCompanyDomain companyDomain = costCompanyDao.selectByNo(planDomain.getCompanyNo());
        planDomain.setCompanyName(companyDomain.getCompanyName());
        planDomain.setCompanyValue(companyDomain.getValue());
        UserDomain user = userDao.select(planDomain.getCreateUsercode());
        planDomain.setCreateUserid(user.getUserid());
        planDomain.setCreateUsername(user.getUsername());

        planDomain.setCreateTime(new Date());

        List<CostPlanTempDomain> list = costPlanTempDao.selectListByPlanNo(planDomain.getCostPlanNo());
        planDomain.setPlanAmount(new BigDecimal(0));
        if (null != list && list.size() >= 1) {
            for (CostPlanTempDomain costPlanTempDomain : list) {
                planDomain.setPlanAmount(planDomain.getPlanAmount().add(costPlanTempDomain.getAmount()));
            }
        }
        return planDomain;
    }
}
