package com.blt.other.auth.controller;


import com.bailuntec.cost.api.response.CostResult;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.blt.other.auth.dto.request.CompanyReviewerListReq;
import com.blt.other.auth.dto.request.DepartmentReviewerListReq;
import com.blt.other.auth.model.OaCompany;
import com.blt.other.auth.model.OaDepartment;
import com.blt.other.auth.service.IOaCompanyService;
import com.blt.other.auth.service.IOaDepartmentService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-10-13
 */
@Api(tags = "审核人接口")
@RestController
@RequestMapping("/costReviewer")
public class CostReviewerController {

    @Resource
    IOaDepartmentService oaDepartmentService;

    @Resource
    IOaCompanyService oaCompanyService;

    @ApiOperation("获取部门审核人配置列表")
    @GetMapping("/departmentReviewerList")
    public CostResult<IPage<OaDepartment>> departmentReviewerList(DepartmentReviewerListReq req) {
        IPage<OaDepartment> oaDepartmentIPage = oaDepartmentService.reviewerList(req);
        return CostResult.success(oaDepartmentIPage);
    }


    @ApiOperation("/修改最终审核人")
    @GetMapping("/modifyFinalReviewer")
    public CostResult<Void> modifyFinalReviewer(@RequestParam Integer userId,
                                                @RequestParam Integer oaCompanyId,
                                                @RequestParam Integer finalReviewerUserId) {
        oaCompanyService.modifyFinalReviewer(userId, oaCompanyId, finalReviewerUserId);
        return CostResult.success();
    }


    @ApiOperation("/修改财务审核人")
    @GetMapping("/modifyFinancialReviewer")
    public CostResult<Void> modifyFinancialReviewer(@RequestParam Integer userId,
                                                    @RequestParam Integer oaCompanyId,
                                                    @RequestParam List<Integer> financialReviewerUserIds) {
        oaCompanyService.modifyFinancialReviewer(userId, oaCompanyId, financialReviewerUserIds);
        return CostResult.success();
    }


    @ApiOperation("获取财务审核人配置列表")
    @GetMapping("/companyReviewerList")
    public CostResult<IPage<OaCompany>> companyReviewerList(CompanyReviewerListReq req) {
        IPage<OaCompany> oaCompanyIPage = oaCompanyService.reviewerList(req);
        return CostResult.success(oaCompanyIPage);
    }


    @ApiOperation("/修改部门审核人")
    @GetMapping("/modifyDepartmentReviewer")
    public CostResult<Void> modifyDepartmentReviewer(@RequestParam Integer userId,
                                                     @RequestParam Integer oaDepartmentId,
                                                     @RequestParam String departmentReviewerUserIds) {
        oaDepartmentService.modifyFinancialReviewer(userId, oaDepartmentId, Lists.newArrayList(departmentReviewerUserIds.split(","))
                .stream().map(Integer::valueOf).collect(Collectors.toList())));
        return CostResult.success();
    }

}
