package com.blt.other.other_cost.controller;

import com.blt.other.other_commons.utils.DateTimeUtil;
import com.blt.other.other_cost.dto.LogisticsCostDto;
import com.blt.other.other_cost.dto.ManageCostDto;
import com.blt.other.other_cost.service.CostApiService;
import com.blt.other.other_cost.service.CostService;
import com.blt.other.other_database.model.CostDomain;
import com.blt.other.other_purchasing.dto.BuyListDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@RestController
@RequestMapping("/cost/api")
public class CostApiController {

    @Autowired
    private CostApiService costApiService;

    private static Logger logger = LoggerFactory.getLogger(CostApiController.class);

    /**
     * 接收物流单，自动生成付款费用单到财务审核
     * @return
     */
    @PostMapping("/pushLogisticsCost")
    public Map<String, Object> pushLogisticsCost(@RequestBody LogisticsCostDto logisticsCostDto){
        logger.warn("接收推送而来的物流单信息：" + logisticsCostDto);
        Map<String,Object> result = new HashMap<>();
        try {
            String costNo = costApiService.generateLogisticsCost(1, logisticsCostDto);
            result.put("success", true);
            result.put("message", costNo);
        } catch (Exception e) {
            e.printStackTrace();
            result.put("success", false);
            result.put("message", "生成物流付款费用单发生错误：" + e.getMessage());
            logger.error("生成物流付款费用单发生错误：" + e.getMessage());
        }
        return result;
    }
    /**
     * 吴通
     * 接收物流单，自动生成收款费用单到财务审核
     * @return
     */
    @PostMapping("/pushLogisticsReceipt")
    public Map<String, Object> pushLogisticsReceipt(@RequestBody LogisticsCostDto logisticsCostDto){
        logger.warn("接收推送而来的物流单信息：" + logisticsCostDto);
        Map<String,Object> result = new HashMap<>();
        try {
            String costNo = costApiService.generateLogisticsCost(2, logisticsCostDto);
            result.put("success", true);
            result.put("message", costNo);
        } catch (Exception e) {
            e.printStackTrace();
            result.put("success", false);
            result.put("message", "生成物流收款费用单发生错误：" + e.getMessage());
            logger.error("生成物流收款费用单发生错误：" + e.getMessage());
        }
        return result;
    }

    @GetMapping("/manageCostList")
    public Map<String, Object> manageCostList(@RequestParam(name = "startDate", required = false) String startDateStr,
                                              @RequestParam(name = "endDate", required = false) String endDateStr,
                                              @RequestParam(name = "feeSuperType", required = false) String feeSuperType,
                                              @RequestParam(name = "feeSubType", required = false) String feeSubType,
                                              @RequestParam(name = "companyValue", required = false) Integer companyValue,
                                              @RequestParam(name = "companyName", required = false) String companyName,
                                              @RequestParam(name = "departmentName", required = false) String departmentName,
                                              @RequestParam(name = "createUserId", required = false) Integer createUserId,
                                              @RequestParam(name = "payUserId", required = false) Integer payUserId){
        Map<String,Object> result = new HashMap<>();
        try {
            if (!StringUtils.isEmpty(departmentName)){
                departmentName = departmentName.toLowerCase();
            }
            List<ManageCostDto> manageCostDtoList = costApiService.getMangeCostList(startDateStr, endDateStr, feeSuperType, feeSubType, companyValue, companyName, departmentName, createUserId, payUserId);
            result.put("success", true);
            result.put("data", manageCostDtoList);
        } catch (ParseException e) {
            e.printStackTrace();
            result.put("success", false);
        } catch (Exception e) {
            e.printStackTrace();
            result.put("success", false);
        }
        return result;
    }

    @GetMapping("/balanceSheetCost")
    public Map<String, Object> balanceSheetCostList(@RequestParam(name = "startDate") String startDateStr,
                                                    @RequestParam(name = "endDate") String endDateStr){
        logger.warn("获取资产负债表相关费用单");
        Map<String,Object> result = new HashMap<>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date startDate = sdf.parse(startDateStr);
            Date endDate = sdf.parse(endDateStr);
            List<CostDomain> balanceSheetCostList = costApiService.getBalanceSheetCost(startDate, endDate);
            result.put("success", true);
            result.put("data", balanceSheetCostList);
        } catch (ParseException e){
            e.printStackTrace();
            result.put("success", false);
        }
        return result;
    }

    @GetMapping("/noPayCost")
    public  Map<String, Object> getNoPayCost(@RequestParam(name = "costNoList") List<String> costNoList){
        Map<String, Object> result = new HashMap<>();
        if(costNoList != null && costNoList.size() > 0){
            List<CostDomain> costDomainList = costApiService.getNoPayCost(costNoList);
            result.put("success", true);
            result.put("data", costDomainList);
        }else{
            result.put("success", false);
            result.put("data", null);
        }
        return result;
    }

    /**
     * 吴通新增
     * 根据费用单号获取费用单大类
     * @param costNo
     * @return
     */
    @GetMapping("/type/{costNo}")
    public Map<String,Object> getTypeName(@PathVariable("costNo")String costNo) {
        // 获取费用单详细信息
        Map<String,Object> result = new HashMap<>();
        try {
            CostDomain costDomain = costApiService.getCostDetails(costNo);
            result.put("success", true);
            result.put("data", costDomain.getTypeName());
        } catch (Exception e) {
            e.printStackTrace();
            result.put("success", false);
        }
        return result;
    }
}
