package com.blt.other.module.database.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

@Data
public class CostLogDomain {

    public static final int TYPE_UPDATE = 1;
    public static final int MANUAL_CHECK = 2;
    public static final int AUTO_CHECK = 3;
    private Integer id; // 费用单日志
    private String costNo; // 费用单号
    private String updateUsercode; // 更新人编号
    private String updateUsername; // 更新人姓名

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime; // 更新时间
    private String updateNote;
    private Integer updateUserid; // 更新人 ID


    //1-更新费用单 2-审核费用单 3-自动审核费用单
    private Integer type;
}
