package com.blt.other.module.cost.controller.cost;

import com.bailuntec.cost.api.dto.CostDto;
import com.blt.other.common.util.AxiosUtil;
import com.blt.other.module.cost.dto.CostApiDto;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = "费用审核接口")
@RestController
@RequestMapping("cost/check")
public class CostCheckController {

    private static Logger logger = LoggerFactory.getLogger(CostCheckController.class);

    @Autowired
    private CostService costService;
    @Autowired
    private CostCompanyService costCompanyService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private CostTofinanceService costTofinanceService;
    @Autowired
    private CostApplycallbackService costApplycallbackService;
    @Autowired
    private CostCashiercallbackService costCashiercallbackService;
    @Autowired
    private CostLogService costLogService;

    @Value("${url.api.getExchangeRateApi}")
    private String getExchangeRateApi;


    /**
     * 改变费用单状态
     *
     * @param costNo
     * @param costStatus
     * @return
     */
    private CostApiDto.UpdateCostResp changeStatus(String costNo, Integer costStatus) {
        CostDomain costDomain = costService.getCostByCostNo(costNo);
        costDomain.setCostNo(costNo);
        costDomain.setCostStatus(costStatus);
        if (costStatus == 2) {
            costDomain.setAuditTime(new Date());
        }
        if (null != costDomain.getIsLend()) {
            if (1 == costDomain.getIsLend() && 4 == costStatus) {
                costDomain.setLendStatus(1);
            }
        }

        return costService.updateCost(costDomain);

    }

    // ================================== 结束费用 ======================================================
    @PostMapping("finish")
    public CostApiDto.UpdateCostResp finish(HttpServletRequest request, HttpServletResponse response) {
        AxiosUtil.setCors(response, request);

        String costNo = request.getParameter("costNo");
        return changeStatus(costNo, 7);
    }

    // ================================== 文件下载 ======================================================
    @GetMapping("download")
    public ResponseEntity<InputStreamResource> download(HttpServletRequest request, HttpServletResponse response) throws IOException {
//        AxiosUtil.setCors(response,request);
        String costNo = request.getParameter("costNo");
        String fileType = request.getParameter("fileType");
        CostDomain costByCostNo = costService.getCostByCostNo(costNo);
        CostDto cost = costByCostNo.castToDto();

        String filePath = null;
        String fileName = null;
        if ("file".equals(fileType)) {
            filePath = cost.getFilePath();
            fileName = cost.getFileName();
        } else if ("morFile".equals(fileType)) {
            filePath = cost.getMorFilePath();
            fileName = cost.getMorFileName();
        }
        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"), "iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }

    /**
     * 借支单结清
     *
     * @param response
     * @param request
     * @return
     */
    @ApiOperation("借支单结清")
    @PostMapping("/finishLend")
    public CostApiDto.UpdateCostResp finishLend(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String costNo = request.getParameter("costNo");
        String updateuserid = request.getParameter("updateuserid");
        CostDomain costDomain = new CostDomain();
        costDomain.setCostNo(costNo);
        costDomain.setLendStatus(4);
        CostApiDto.UpdateCostResp resp = costService.updateCost(costDomain);
        resp.setMsg("已结清");
        costLogService.save(costNo, Integer.parseInt(updateuserid), "操作结清");
        return resp;
    }

    @GetMapping("downCashierAnnex")
    public Map<String, Object> downCashierAnnex(HttpServletRequest request, HttpServletResponse response) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        List<String> list = costCashiercallbackService.downCashierAnnex();
        result.put("success", true);
        result.put("msg", "出纳单附件下载完成");
        return result;
    }
}
