package com.blt.other.module.cost.service.impl.costplan;

import com.bailuntec.cost.api.dto.CostPlanDto;
import com.blt.other.common.util.PathUtil;
import com.blt.other.module.auth.dao.UserDao;
import com.blt.other.module.cost.dao.*;
import com.blt.other.module.cost.dto.CostPlanApiDto;
import com.blt.other.module.cost.service.*;
import com.blt.other.module.cost.utils.CostFileUtil;
import com.blt.other.module.cost.utils.CostUtils;
import com.blt.other.module.database.model.*;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/16 1:28 下午
 */
public abstract class AbstractCostPlanService implements CostPlanService {


    @Autowired
    UserCostFinansysService userCostFinansysService;
    @Autowired
    CostPlanDao costPlanDao;
    @Autowired
    CostCompanyDao costCompanyDao;
    @Autowired
    UserDao userDao;
    @Autowired
    CostPlanTempDao costPlanTempDao;
    @Autowired
    CostDao costDao;
    @Autowired
    CostTypeDao costTypeDao;
    @Autowired
    CostTypeKindDao costTypeKindDao;
    @Autowired
    CostService costService;
    @Autowired
    CostPlanTempService costPlanTempService;


    @Value("${url.api.getExchangeRateApi}")
    String getExchangeRateApi;

    @Autowired
    CostLogService costLogService;
    @Autowired
    CostDetailDao costDetailDao;

    /**
     * <p>
     * 保存填写的财务信息到历史记录
     * </p>>
     */
    public void doSaveFinansyRecord(CostPlanDomain planDomain) {
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostPlanDomain(planDomain);
        userCostFinansysService.saveFinansysRecord(finansyRecordByCostDomain);
    }

    /**
     * <p>
     * 补全费用计划参数
     * </p>
     *
     * @param costPlanDomain 费用计划source
     */
    protected void completedCostPlan(CostPlanDomain costPlanDomain) {

        CostCompanyDomain companyDomain = costCompanyDao.selectByNo(costPlanDomain.getCompanyNo());
        costPlanDomain.setCompanyName(companyDomain.getCompanyName());
        costPlanDomain.setCompanyValue(companyDomain.getValue());
        UserDomain user = userDao.select(costPlanDomain.getCreateUsercode());
        costPlanDomain.setCreateUserid(user.getUserid());
        costPlanDomain.setCreateUsername(user.getUsername());
        costPlanDomain.setCreateTime(new Date());

        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(costPlanDomain.getKindNo());

        costPlanDomain.setKindName(costTypeKindDomain.getKindName());
        costPlanDomain.setTypeNo(costTypeKindDomain.getTypeNo());
        costPlanDomain.setTypeName(costTypeKindDomain.getTypeName());

        /*附件字段*/
        if (costPlanDomain.getFileSelect() != null) {
            // 文件上传的路径
            String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/" + costPlanDomain.getCostPlanNo() + "/");
            // 调用工具类执行保存，并返回 path
            String path = CostFileUtil.upload(costPlanDomain.getFileSelect(), filePath);
            costPlanDomain.setFilePath(path);
        }

    }

    @Override
    public String createNo() {

        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddhhmmss");
        String no = "CP" + sdf.format(new Date()) + random.nextInt(9);
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(no);
        while (null != costPlanDomain && null != costPlanDomain.getCostPlanNo()) {
            no = "CP" + sdf.format(new Date()) + random.nextInt(9);
            costPlanDomain = costPlanDao.selectByNo(no);
        }
        return no;
    }


    @Override
    public void deleted(String costPlanNo) {
        costPlanDao.deleted(costPlanNo);
    }

    @Override
    public CostPlanApiDto.GetAllCostPlanResp getAllCostList(CostPlanApiDto.GetAllCostPlanReq req) {
        if (req.getAuthType() != 0) {
            req.setUserId(null);
        }
        PageHelper.startPage(req.getPageNum(), req.getPageSize());

        List<CostPlanDomain> allCostList = costPlanDao.selectAll(req.getUserId());
        PageInfo<CostPlanDomain> pageInfo = new PageInfo<>(allCostList);
        List<CostPlanDto> costPlanDtos = allCostList.stream().map(CostPlanDomain::castToDto).collect(Collectors.toList());

        return new CostPlanApiDto.GetAllCostPlanResp(true, costPlanDtos, pageInfo);
    }

    @Override
    public CostPlanApiDto.GetCostPlanResp getByPlanNo(String planNo) {
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(planNo);
        String filePath = costPlanDomain.getFilePath();
        String fileName = null;
        if (null != filePath && filePath.length() >= 1) {
            String[] split = filePath.split("&");
            if (split.length >= 1) {
                fileName = split[split.length - 1];
            }
        }
        CostPlanApiDto.GetCostPlanResp result = new CostPlanApiDto.GetCostPlanResp();
        result.setCostPlan(costPlanDomain);
        result.setFileName(fileName);
        return result;
    }

    protected CostDomain planToCost(String costPlanNo) {
        CostDomain costDomain = new CostDomain();
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);
        BeanUtils.copyProperties(costPlanDomain, costDomain);
        costDomain.setCompanyValue(costCompanyDao.selectByNo(costPlanDomain.getCompanyNo()).getValue());
        if (costDomain.getTypeNo() != null) {
            CostTypeDomain costTypeDomain = costTypeDao.selectByTypeNo(costDomain.getTypeNo());
            if (costTypeDomain != null) {
                costDomain.setSubjectCode(costTypeDomain.getSubjectCode());
            }
        }
        return costDomain;
    }

    protected CostDetailDomain tempToDetail(CostPlanTempDomain costPlanTempDomain, CostPlanDomain costPlanDomain, Integer index) {
        CostDetailDomain costDetailDomain = new CostDetailDomain();
        BeanUtils.copyProperties(costPlanDomain, costDetailDomain);
        BeanUtils.copyProperties(costPlanTempDomain, costDetailDomain);
        costDetailDomain.setDetailNo(costPlanDomain.getCostPlanNo() + "-" + index);

        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(costPlanTempDomain.getKindNo());
        costDetailDomain.setKindName(costTypeKindDomain.getKindName());
        costDetailDomain.setTypeNo(costTypeKindDomain.getTypeNo());
        costDetailDomain.setTypeName(costTypeKindDomain.getTypeName());
        return costDetailDomain;
    }

    /**
     * 生成 costNo
     *
     * @return costNo
     */
    protected String getCostNo() {
        String costNo = CostUtils.getIdNum(costService);
        CostDomain costByNo = costDao.selectByCostNo(costNo);
        while (null != costByNo && null != costByNo.getId()) {
            costNo = CostUtils.getIdNum(costService);
        }
        return costNo;
    }

}
