package com.blt.other.module.cost.controller.costplan;

import com.blt.other.module.cost.dto.CostPlanNewApiDto;
import com.blt.other.module.cost.service.CostPlanService;
import com.blt.other.module.cost.service.impl.costplan.CostPlanServiceFactory;
import com.blt.other.module.database.model.CostPlanDomain;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Api(tags = "新增费用计划接口")
@RestController
@RequestMapping(value = {"/cost/plan/new/",
        "/cost/plan/new/lend1",
        "/cost/plan/new/lend2",
        "/cost/plan/new/pay",
        "/cost/plan/new/receipt"})
public class CostPlanNewController {


    @ApiOperation("获取新增费用计划编号")
    @GetMapping("/getNo")
    public Map<String, Object> getNo() {

        CostPlanService costPlanService = CostPlanServiceFactory.getCostPlanService();
        String no = costPlanService.createNo();
        Map<String, Object> result = new HashMap<>();
        result.put("costPlanNo", no);
        result.put("success", true);
        return result;
    }


    @ApiOperation("确认费用计划")
    @PostMapping("/affirm")
    public Map<String, Object> affirm(@RequestParam String costPlanNo) {
        Map<String, Object> result = new HashMap<>();
        try {
            CostPlanService costPlanService = CostPlanServiceFactory.getCostPlanService(costPlanNo);

            Integer affirm = costPlanService.affirm(costPlanNo);
            result.put("success", true);
            result.put("msg", "已生成 " + affirm + " 张付款费用单<br>费用列表提交审核");
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            result.put("success", false);
            result.put("msg", "付款计划不存在或发生其他错误");
        }
        return result;
    }

    @ApiOperation("/删除费用计划")
    @PostMapping("/deleted")
    public Map<String, Object> deleted(@RequestParam String costPlanNo) {
        Map<String, Object> result = new HashMap<>();
        try {
            CostPlanService costPlanService = CostPlanServiceFactory.getCostPlanService(costPlanNo);
            costPlanService.deleted(costPlanNo);
            result.put("success", true);
        } catch (Exception ex) {
            result.put("success", false);
            result.put("msg", "发生错误");
        }
        return result;
    }

    @ApiOperation("更新费用计划")
    @PostMapping(value = {"/reset", "resetNoFile", "resetFile"})
    public CostPlanNewApiDto.RestResp reset(CostPlanDomain costPlanDomain) {
        CostPlanService costPlanService = CostPlanServiceFactory.getCostPlanService(costPlanDomain);
        costPlanService.update(costPlanDomain);

        CostPlanNewApiDto.RestResp resp = new CostPlanNewApiDto.RestResp();
        resp.setSuccess(true);
        resp.setMsg("已经修改");
        return resp;
    }

    @ApiOperation("新增费用计划")
    @PostMapping(value = {"/save", "saveNoFile", "saveFile"})
    public CostPlanNewApiDto.SaveResp save(CostPlanDomain costPlanDomain) {
        CostPlanService costPlanService = CostPlanServiceFactory.getCostPlanService(costPlanDomain);

        costPlanService.save(costPlanDomain);
        CostPlanNewApiDto.SaveResp resp = new CostPlanNewApiDto.SaveResp();
        resp.setCostPlanDomain(costPlanDomain);
        resp.setCostPlanNo(costPlanDomain.getCostPlanNo());
        resp.setMsg("success");
        resp.setSuccess(true);
        return resp;
    }


}
