package com.blt.other.module.auth.controller;

import com.blt.other.module.auth.service.GetDeparmentListService;
import com.blt.other.module.auth.vo.DeparmentMsg;
import com.blt.other.common.util.AxiosUtil;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@RestController
@RequestMapping("/deparment")
public class DeparmentController {

    @Resource
    private GetDeparmentListService getDeparmentListService;

    @PostMapping("/getDeparmentByName")
    public DeparmentMsg getDeparmentByName(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String deparmentName = request.getParameter("deparmentName");
        return getDeparmentListService.getDeparment(deparmentName);
    }
}
