package com.blt.other.common.util;


import com.blt.other.common.base.SysUser;

/**
 * 应用会话管理工具类
 */
public class SessionUtils {


    /*当前登录用户*/
    private static final ThreadLocal<SysUser> sysUserThreadLocal = new ThreadLocal<>();


    public static void putSysUser(SysUser sysUser) {
        sysUserThreadLocal.set(sysUser);
    }

    public static SysUser getSysUser() {
        return sysUserThreadLocal.get();
    }

    public static void removeSysUser() {
        sysUserThreadLocal.remove();
    }


    public static Integer getCurrentUserId() {
        return sysUserThreadLocal.get().getOaUserId();
    }

}
