package com.blt.other.module.cost.service.impl.costplan;

import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.module.cost.service.CostPlanService;
import com.blt.other.module.database.model.CostDomain;
import com.blt.other.module.database.model.CostPlanDomain;
import com.blt.other.module.database.model.CostPlanTempDomain;
import com.blt.other.module.database.model.CostTypeKindDomain;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;


/**
 * <p>
 * 借还单服务
 * </p>
 *
 * @author robbendev
 * @since 2020/10/16 1:25 下午
 */
@Slf4j
@Service
@Transactional(rollbackFor = Exception.class)
public class CostPlanNewLend2ServiceImpl extends AbstractCostPlanService implements CostPlanService {
    @Override
    public void save(CostPlanDomain planDomain) {
        this.doSaveFinansyRecord(planDomain);
        this.completedCostPlan(planDomain);
        planDomain.setCostPlanStatus(0);
        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(planDomain.getKindNo());

        planDomain.setKindName(costTypeKindDomain.getKindName());
        planDomain.setTypeNo(costTypeKindDomain.getTypeNo());
        planDomain.setTypeName(costTypeKindDomain.getTypeName());

        costPlanDao.insert(planDomain);
    }

    @Override
    public void update(CostPlanDomain planDomain) {
        this.doSaveFinansyRecord(planDomain);
        this.completedCostPlan(planDomain);

        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(planDomain.getKindNo());

        planDomain.setKindName(costTypeKindDomain.getKindName());
        planDomain.setTypeNo(costTypeKindDomain.getTypeNo());
        planDomain.setTypeName(costTypeKindDomain.getTypeName());

        costPlanDao.update(planDomain);
    }

    @Override
    public Integer affirm(String costPlanNo) {

        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);
        if (costPlanDomain.getCostPlanStatus() != 0) {
            throw new BizRuntimeException("只能更新待确认的计划单");
        }
        costPlanDomain.setCostPlanStatus(1);
        costPlanDao.update(costPlanDomain);

        // 借还单确认时，根据借支单金额、冲销金额、余额拆单
        if (null == costPlanDomain.getIsTax()) {
            costPlanDomain.setIsTax(0);
        }
        CostDomain supCost = costDao.selectByCostNo(costPlanDomain.getSupCostNo());
        // 关联借支单还需还差额 subtract
        if (null == supCost.getHadPay()) {
            supCost.setHadPay(new BigDecimal(0));
        }
        if (null == supCost.getCounteract()) {
            supCost.setCounteract(new BigDecimal(0));
        }
        if (null == supCost.getLendBalance()) {
            supCost.setLendBalance(new BigDecimal(0));
        }
        BigDecimal subtract = supCost.getAmount().subtract(supCost.getHadPay());
        BigDecimal counteract = costPlanDomain.getCounteract();
        BigDecimal lendBalance = costPlanDomain.getLendBalance();
        BigDecimal numZero = new BigDecimal(0);

        int result = 0;
        if (counteract.compareTo(numZero) == 0 && lendBalance.compareTo(numZero) == 1) {
            // 1、冲销 0，还 大于0 ==== 生成一张收款的借还单
            CostDomain costDomain = planToCost(costPlanDomain.getCostPlanNo());
            costDomain.setCostNo(getCostNo());
            costDomain.setCostStatus(0);
            costDomain.setAmount(costPlanDomain.getPlanAmount());
            BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY", getExchangeRateApi);
            costDomain.setToRmbRate(toRmbRate);
            costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
            Integer insert = costDao.insert(costDomain);
            if (null != insert && insert == 1) {
                log.info("1、冲销 0，还 大于0 ==== 生成一张收款的借还单: " + costDomain);
                // 记录日志
                costLogService.save(costDomain.getCostNo(), costDomain.getCreateUserid(), "由费用计划：" + costDomain.getCostPlanNo() + " 生成收款借还单");
                result = 1;
            } else {
                log.error("1、冲销 0，还 大于0 ==== 生成一张收款的借还单失败: " + costDomain);
            }
        } else if (counteract.compareTo(numZero) == 1 && lendBalance.compareTo(numZero) == 0) {
            // 2、冲销 大于 0，还 0
            if (counteract.compareTo(subtract) == 0 || counteract.compareTo(subtract) == -1) {
                // 2.1、冲销刚好抵消差额 / 冲销小于差额  ===== 生成一张无需付款的借还单
                CostDomain costDomain = planToCost(costPlanDomain.getCostPlanNo());
                costDomain.setCostNo(getCostNo());
                costDomain.setCostStatus(0);
                costDomain.setAmount(costPlanDomain.getPlanAmount());
                BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY", getExchangeRateApi);
                costDomain.setToRmbRate(toRmbRate);
                costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
                Integer insert = costDao.insert(costDomain);
                if (null != insert && insert == 1) {
                    log.info("2.1、冲销刚好抵消差额 / 冲销小于差额  ===== 生成一张无需付款的借还单：" + costDomain);
                    // 记录日志
                    costLogService.save(costDomain.getCostNo(), costDomain.getCreateUserid(),
                            "由费用计划：" + costDomain.getCostPlanNo() + " 生成冲销单");
                    result = 1;
                } else {
                    log.info("2.1、冲销刚好抵消差额 / 冲销小于差额  ===== 生成一张无需付款的借还单失败：" + costDomain);
                }
            } else {
                // 2.2、冲销大于差额  ===== 生成一张无需收款的借还单 + 一张付款单（出纳回调接口和财务审核接口改为借还出纳回调接口，费用单号以 “S” 打头）
                log.info("2.2、冲销大于差额  ===== 准备生成一张无需收款的借还单 + 一张付款单（出纳回调接口和财务审核接口改为借还出纳回调接口，费用单号以 “S” 打头）");
                CostDomain costDomain1 = planToCost(costPlanDomain.getCostPlanNo());
                costDomain1.setCostNo(getCostNo());
                costDomain1.setCostStatus(0);
                costDomain1.setAmount(subtract);
                costDomain1.setCounteract(subtract);
                costDomain1.setPayPlanAmount(subtract.divide(costPlanDomain.getPayCur(), 4));
                costDomain1.setPayCounteract(subtract.divide(costPlanDomain.getPayCur(), 4));
                BigDecimal toRmbRate = CurUtils.getCur(costDomain1.getDic(), "CNY", getExchangeRateApi);
                costDomain1.setToRmbRate(toRmbRate);
                costDomain1.setAmountRmb(costDomain1.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
                Integer insert1 = costDao.insert(costDomain1);
                if (null != insert1 && insert1 == 1) {
                    log.info("生成一张无需收款的借还单：" + costDomain1);
                    // 记录日志
                    costLogService.save(costDomain1.getCostNo(), costDomain1.getCreateUserid(),
                            "由费用计划：" + costDomain1.getCostPlanNo() + " 生成冲销单");
                } else {
                    log.info("生成一张无需收款的借还单失败：" + costDomain1);
                }
                result = result + insert1;

                /**
                 *  改为生成一张待提交的付款计划   且必须选择付款子项后才能确认（前端判断costTemps，后端判断是否有子项目）
                 *  差额计划单生成付款费用单时，费用单号保留 S 打头
                 *  差额计划单的总额、创建一个空的子项目，但是不选类型
                 *  前端 costForm = 1  isLend = 2 时，不可以删除自动生成的空的子项目，只能修改（后端删除子项目的环节同样需要判断）
                 */
                CostPlanDomain payPlan = new CostPlanDomain();
                BeanUtils.copyProperties(costPlanDomain, payPlan);
                BigDecimal compensate = costPlanDomain.getCounteract().subtract(subtract);
                payPlan.setCostPlanNo("S" + createNo());
                payPlan.setCostPlanStatus(0);
                payPlan.setCostForm(1);
                payPlan.setIsLend(2);
                payPlan.setPlanAmount(compensate);
                payPlan.setPayPlanAmount(compensate.divide(costPlanDomain.getPayCur(), 4));
                payPlan.setCounteract(new BigDecimal(0));
                payPlan.setPayCounteract(new BigDecimal(0));
                payPlan.setIsTax(0);
                payPlan.setTypeNo(null);
                payPlan.setTypeName(null);
                payPlan.setKindName(null);
                payPlan.setKindNo(null);
                payPlan.setCostReason("借支差额：" + payPlan.getSupCostNo());
                Integer insert2 = costPlanDao.insert(payPlan);
                if (insert2 == 1) {
                    log.info("生成一张补差额的付款单计划：" + payPlan);
                    // 生成空子类的子项目
                    CostPlanTempDomain temp = new CostPlanTempDomain();
                    temp.setTempNo(costPlanTempService.createNo());
                    temp.setCostPlanNo(payPlan.getCostPlanNo());
                    temp.setCostReason("借支差额：" + payPlan.getSupCostNo());
                    temp.setAmount(payPlan.getPlanAmount());
                    temp.setDic(payPlan.getDic());
                    Integer insert = costPlanTempDao.insert(temp);
                    if (null != insert && insert == 1) {
                        log.info("生成差额单子项目 " + temp);
                    }
                    // 借支单的补差额添加金额
                    if (null == supCost.getCompensate()) {
                        supCost.setCompensate(new BigDecimal(0));
                    }
                    supCost.setCompensate(supCost.getCompensate().add(payPlan.getPlanAmount()));
                    costDao.update(supCost);

                } else {
                    log.info("生成一张补差额的付款单失败：" + costDomain1);
                }
            }
        } else if (counteract.compareTo(numZero) == 1 && lendBalance.compareTo(numZero) == 1) {
            // 3、冲销 大于 0，还 大于0 生成一张无需付款的借还单，一张收款的借还单
            log.info("3、冲销 大于 0，还 大于0 ，准备生成一张无需付款的借还单，一张收款的借还单");
            CostDomain costDomain1 = planToCost(costPlanDomain.getCostPlanNo());
            costDomain1.setCostNo(getCostNo());
            costDomain1.setCostStatus(0);
            costDomain1.setAmount(costDomain1.getCounteract());
            costDomain1.setLendBalance(new BigDecimal(0));
            costDomain1.setPayPlanAmount(costDomain1.getPayCounteract());
            costDomain1.setPayLendBalance(new BigDecimal(0));
            BigDecimal toRmbRate = CurUtils.getCur(costDomain1.getDic(), "CNY", getExchangeRateApi);
            costDomain1.setToRmbRate(toRmbRate);
            costDomain1.setAmountRmb(costDomain1.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
            Integer insert1 = costDao.insert(costDomain1);
            if (null != insert1 && insert1 == 1) {
                log.info("生成一张无需付款的借还单：" + costDomain1);
                costLogService.save(costDomain1.getCostNo(), costDomain1.getCreateUserid(),
                        "由费用计划：" + costDomain1.getCostPlanNo() + " 生成冲销单");
            } else {
                log.info("生成一张无需付款的借还单失败：" + costDomain1);
            }
            result = result + insert1;

            CostDomain costDomain2 = planToCost(costPlanDomain.getCostPlanNo());
            costDomain2.setCostNo(getCostNo());
            costDomain2.setCostStatus(0);
            costDomain2.setAmount(costDomain2.getLendBalance());
            costDomain2.setCounteract(new BigDecimal(0));
            costDomain2.setPayPlanAmount(costDomain2.getPayLendBalance());
            costDomain2.setPayCounteract(new BigDecimal(0));
            BigDecimal toRmbRate1 = CurUtils.getCur(costDomain2.getDic(), "CNY", getExchangeRateApi);
            costDomain2.setToRmbRate(toRmbRate1);
            costDomain2.setAmountRmb(costDomain2.getAmount().multiply(toRmbRate1).setScale(2, BigDecimal.ROUND_HALF_UP));
            Integer insert2 = costDao.insert(costDomain2);
            if (null != insert2 && insert2 == 1) {
                log.info("生成一张收款的借还单：" + costDomain2);
                costLogService.save(costDomain2.getCostNo(), costDomain2.getCreateUserid(),
                        "由费用计划：" + costDomain2.getCostPlanNo() + " 生成收款借还单");
            } else {
                log.info("生成一张收款的借还单：" + costDomain2);
            }
            result = result + insert2;
        }
        return result;

    }
}
