package com.blt.other.module.cost.service;

import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.LogisticsCostDto;
import com.bailuntec.cost.api.dto.ManageCostDto;
import com.bailuntec.cost.api.dto.WageCostDto;
import com.blt.other.module.database.model.CostDomain;
import org.springframework.cglib.core.Local;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

public interface CostApiService {
    /**
     * 接收物流单，自动生成付款费用单到财务审核
     *
     * @param costForm         费用单类型
     * @param logisticsCostDto 物流单
     * @return 费用单编号
     */
    String generateLogisticsCost(int costForm, LogisticsCostDto logisticsCostDto) throws Exception;

    /**
     * <p>
     * 查询所有的费用单和采购单
     * </p>
     *
     * @param startDateStr   开始时间
     * @param endDateStr     开始时间
     * @param feeSuperType   大类
     * @param feeSubType     小类
     * @param companyValue   公司主体value
     * @param companyName    主体名称
     * @param departmentName 部门
     * @param createUserId   创建用户id
     * @param payUserId      支付用户id
     * @return 单据
     */
    List<ManageCostDto> getMangeCostList(LocalDateTime startDateStr, LocalDateTime endDateStr, String feeSuperType, String feeSubType, Integer companyValue, String companyName, String departmentName, Integer createUserId, Integer payUserId) throws Exception;


    /**
     * <p>
     * 查询所有的物流的费用单和采购单
     * </p>
     *
     * @param startDateStr   开始时间
     * @param endDateStr     开始时间
     * @param feeSuperType   大类
     * @param feeSubType     小类
     * @param companyValue   公司主体value
     * @param companyName    主体名称
     * @param departmentName 部门
     * @param createUserId   创建用户id
     * @param payUserId      支付用户id
     * @return 单据
     */
    List<ManageCostDto> getLogisticsCostList(LocalDateTime startDateS, LocalDateTime endDateStr, String feeSuperType, String feeSubType, Integer companyValue, String companyName, String departmentName, Integer createUserId, Integer payUserId) throws Exception;

    /**
     * 查询资产负债表相关费用单
     *
     * @param startDate
     * @param endDate
     * @return
     */
    List<CostDomain> getBalanceSheetCost(Date startDate, Date endDate);

    /**
     * <p>
     * 根据费用单号列表
     * 查询原来传输到数据中心时为待支付状态 变成 已支付状态后的费用单
     * </p>
     *
     * @param costNoList 费用单号
     * @return 费用单列表
     */
    List<CostDomain> getNoPayCost(List<String> costNoList);


    CostDomain getCostDetails(String costNo);

    /**
     * <p>
     * 接受工资单，自动生成付款费用单到财务审核
     * </p>
     *
     * @param wageCostDto 工资单入参
     * @return 费用单costNo
     */
    String pushWageCost(WageCostDto wageCostDto) throws IOException;

    /**
     * <p>
     * 根据最后更新时间获取费用单
     * </p>
     *
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 费用单list
     */
    List<CostDto> getCostList(String startDate, String endDate);
}
