package com.blt.other.module.cost.dao;

import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.ManageCostDto;
import com.blt.other.module.cost.vo.CostExportVo;
import com.blt.other.module.database.model.CostDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Mapper
@Repository
public interface CostDao {
    /**
     * insert 费用单记录
     *
     * @param costDomain
     * @return
     */
    Integer insert(CostDomain costDomain);

    /**
     * 获取费用单列表
     */
    List<CostDomain> selectAll(@Param("userId") Integer userId, @Param("projectTypeList") List<String> projectTypeList);

    /**
     * 根据 costNo 获取费用单详情
     *
     * @param costNo
     * @return
     */
    CostDomain selectByCostNo(String costNo);

    /**
     * 修改费用单信息
     *
     * @param costDomain
     * @return
     */
    Integer update(CostDomain costDomain);

    /**
     * 获取 status >= costStatus(param) 的费用单
     *
     * @return
     */
    List<CostDomain> selectByStatus(Integer costStatus);

    /**
     * 根据借支类型获取费用列表
     *
     * @param isLend
     * @return
     */
    List<CostDomain> selectByLend(Integer isLend);

    /**
     * 根据关键字获取费用单
     *
     * @return
     */
    List<CostDomain> selectByKey(@Param("searchKey") String searchKey, @Param("costStatus") Integer costStatus);

    List<CostDomain> selectByCostStatus(Integer costStatus);

    List<CostDomain> selectByLendStatus(Integer lendStatus);

    List<CostDomain> selectByCostForm(Integer costForm);

    List<CostDomain> selectByCostFormAndStatus(@Param("costForm") Integer costForm, @Param("costStatus") Integer costStatus);

    List<CostDomain> selectBySupCostNo(String supCostNo);

    List<CostDomain> selectByKeys(CostDomain costDomain);

    List<CostDomain> selectByLendAndStatus(@Param("isLend") Integer isLend, @Param("costStatus") Integer costStatus);

    List<CostDomain> selectByCostPlanNo(String costPlanNo);

    Integer updateById(CostDomain costDomain);

    CostDomain selectLastCost();

    List<CostDomain> selectLinkLendCost(@Param("createuserid") Integer createuserid);

    /**
     * 查询管理成本费用列表，付款单+借还单
     *
     * @param startDate        startDate
     * @param endDate          endDate
     * @param feeSuperType     feeSuperType
     * @param feeSubType       feeSubType
     * @param companyValueList companyValueList
     * @param companyName      companyName
     * @param departmentName   departmentName
     * @param createUserId     createUserId
     * @param payUserId        payUserId
     * @return
     */
    List<ManageCostDto> selectManageCost(@Param("startDate") LocalDateTime startDate,
                                         @Param("endDate") LocalDateTime endDate,
                                         @Param("feeSuperType") String feeSuperType,
                                         @Param("feeSubType") String feeSubType,
                                         @Param("companyValueList") List<Integer> companyValueList,
                                         @Param("companyName") String companyName,
                                         @Param("departmentName") String departmentName,
                                         @Param("createUserId") Integer createUserId,
                                         @Param("payUserId") Integer payUserId);

    /**
     * <p>
     * 查询所有的物流费用单和采购单
     * </p>
     *
     * @param startDate        startDate
     * @param endDate          endDate
     * @param feeSuperType     feeSuperType
     * @param feeSubType       feeSubType
     * @param companyValueList companyValueList
     * @param companyName      companyName
     * @param departmentName   departmentName
     * @param createUserId     createUserId
     * @param payUserId        payUserId
     * @return
     */
    List<ManageCostDto> getLogisticsCostList(@Param("startDate") LocalDateTime startDate,
                                             @Param("endDate") LocalDateTime endDate,
                                             @Param("feeSuperType") String feeSuperType,
                                             @Param("feeSubType") String feeSubType,
                                             @Param("companyValueList") List<Integer> companyValueList,
                                             @Param("companyName") String companyName,
                                             @Param("departmentName") String departmentName,
                                             @Param("createUserId") Integer createUserId,
                                             @Param("payUserId") Integer payUserId);

    /**
     * 查询资产负债表相关费用单
     *
     * @param startDate
     * @param endDate
     * @return
     */
    List<CostDomain> selectBalanceSheetCost(@Param("startDate") Date startDate, @Param("endDate") Date endDate);

    /**
     * 查询原来传输到数据中心时为待支付状态 变成 已支付状态后的费用单
     *
     * @param costNoList 费用单号
     * @return 费用单
     */
    List<CostDomain> selectNoPayCost(@Param("list") List<String> costNoList);

    Integer selectCostStatusByNo(@Param("costNo") String costNo);

    List<CostDto> getCostByRejectStatus();

    List<String> listCostNo();

    List<String> listCostNoAll(CostExportVo costExportVo);

    Integer updateCashierAnnex(@Param("costNo") String costNo, @Param("filePath") String filePath, @Param("downloadUrl") String downloadUrl);

    List<CostDto> getCostList(@Param("startDate") String startDate, @Param("endDate") String endDate);
}
