package com.blt.other.supplier.config;

import com.blt.other.supplier.job.BuyUserSyncJob;
import org.quartz.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 定时器配置
 */
@Configuration
public class BuyUserSyncConfiguration {

    // 扫描采购员列表时间间隔：（秒）
    private static final int TIME = 259200;

    // JobDetail 定义要执行的 job
    @Bean
    public JobDetail buyUserSyncJobJobDetail(){
        return JobBuilder.newJob(BuyUserSyncJob.class)
                .withIdentity("buyUserSyncJob")
                .storeDurably().build();
    }

    // 触发 Bean 的 Trigger
    @Bean
    public Trigger buyUserSyncJobTrigger(){
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule()
                .withIntervalInSeconds(TIME).repeatForever();
        return TriggerBuilder.newTrigger().forJob(buyUserSyncJobJobDetail())
                .withIdentity("buyUserSuncTrigger")
                .withSchedule(simpleScheduleBuilder).build();
    }
}
