package com.blt.other.cost.service;

import com.bailuntec.cost.api.dto.CostTypeDto;
import com.blt.other.database.model.TypeRelationDomain;
import com.blt.other.database.model.CostTypeDomain;

import java.util.List;

public interface CostTypeService {

    /**
     * 通过 companyNo 获取类型列表
     * @param companyNo
     * @return
     */
    List<CostTypeDto> getListByCompanyNo(String companyNo);

    /**
     * 保存费用类型
     * @return
     */
    Integer saveNewType(CostTypeDomain costTypeDomain);

    /**
     * 获取所有类型
     * @return
     */
    List<CostTypeDomain> getAllType();

    CostTypeDto domainToDto(CostTypeDomain costTypeDomain);

    CostTypeDomain getByTypeNo(String typeNo);

    TypeRelationDomain getTyeRelation(String typeName);

    Integer insertTypeRalation(String typeName);
}
