package com.blt.other.commons.service.impl;

import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostPlanDto;
import com.blt.other.commons.dao.IndexDao;
import com.blt.other.commons.service.IndexService;
import com.blt.other.cost.service.CostListSearchService;
import com.blt.other.cost.service.CostPlanService;
import com.blt.other.database.model.BuyPlanDomain;
import com.blt.other.database.model.CostDomain;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.purchasing.dto.BuyPlanDto;
import com.blt.other.purchasing.service.BuyPlanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class IndexServiceImpl implements IndexService {

    @Autowired
    private IndexDao indexDao;
    @Autowired
    private BuyPlanService buyPlanService;
    @Autowired
    private CostPlanService costPlanService;
    @Autowired
    private CostListSearchService costListSearchService;

    @Override
    public List<BuyPlanDto> getBuyPlanList(Integer userid) {
        List<BuyPlanDomain> buyPlanDomains = indexDao.selectBuyPlanList(userid);
        List<BuyPlanDto> dtoList = buyPlanService.getDtoList(buyPlanDomains);
        return dtoList;
    }

    @Override
    public List<CostPlanDto> getCostPlanList(Integer userid) {
        List<CostPlanDomain> costPlanDomains = indexDao.selectCostPlanList(userid);
        return costPlanDomains.stream().map(CostPlanDomain::castToDto).collect(Collectors.toList());
    }

    @Override
    public List<CostDto> getCostList(Integer userid) {
        List<CostDomain> costDomains = indexDao.selectCostList(userid);
        return costListSearchService.domainListToDto(costDomains);
    }

}
