package com.bailuntec.cost.api;


import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.LogisticsCostDto;
import com.bailuntec.cost.api.dto.ManageCostDto;
import com.bailuntec.cost.api.dto.WageCostDto;
import com.bailuntec.cost.api.response.CostResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@FeignClient(name = "bailuntec-cost-api", url = "")
public interface CostApi {


    /**
     * <p>
     * 推送工资单到财务审核
     * </p>
     *
     * @param wageCostDto 工资单入参
     * @return 费用单No
     */
    @PostMapping("/pushWageCost")
    CostResult<Void> pushWageCost(@RequestBody WageCostDto wageCostDto);

    /**
     * 接收物流单，自动生成付款费用单到财务审核
     *
     * @return 费用单No
     */
    @PostMapping("/pushLogisticsCost")
    CostResult<Void> pushLogisticsCost(@RequestBody LogisticsCostDto logisticsCostDto);

    /**
     * 吴通
     * 接收物流单，自动生成收款费用单到财务审核
     *
     * @return costNo
     */
    @PostMapping("/pushLogisticsReceipt")
    CostResult<Void> pushLogisticsReceipt(@RequestBody LogisticsCostDto logisticsCostDto);

    /**
     * 获取所有费用单和采购单
     *
     * @param startDateStr   date
     * @param endDateStr     date
     * @param feeSuperType   大类
     * @param feeSubType     小类
     * @param companyValue   公司
     * @param companyName    公司
     * @param departmentName 部门
     * @param createUserId   创建用户id
     * @param payUserId      支付用户id
     * @return 所有费用单和采购单
     */
    @GetMapping("/manageCostList")
    CostResult<List<ManageCostDto>> manageCostList(@RequestParam(name = "startDate", required = false) String startDateStr,
                                                   @RequestParam(name = "endDate", required = false) String endDateStr,
                                                   @RequestParam(name = "feeSuperType", required = false) String feeSuperType,
                                                   @RequestParam(name = "feeSubType", required = false) String feeSubType,
                                                   @RequestParam(name = "companyValue", required = false) Integer companyValue,
                                                   @RequestParam(name = "companyName", required = false) String companyName,
                                                   @RequestParam(name = "departmentName", required = false) String departmentName,
                                                   @RequestParam(name = "createUserId", required = false) Integer createUserId,
                                                   @RequestParam(name = "payUserId", required = false) Integer payUserId);

    /**
     * 获取所有物流的费用单
     *
     * @param startDateStr   date
     * @param endDateStr     date
     * @param feeSuperType   大类
     * @param feeSubType     小类
     * @param companyValue   公司
     * @param companyName    公司
     * @param departmentName 部门
     * @param createUserId   创建用户id
     * @param payUserId      支付用户id
     * @return 所有费用单和采购单
     */
    @GetMapping("/logisticsCostList")
    CostResult<List<ManageCostDto>> logisticsCostList(@RequestParam(name = "startDate", required = false) String startDateStr,
                                                      @RequestParam(name = "endDate", required = false) String endDateStr,
                                                      @RequestParam(name = "feeSuperType", required = false) String feeSuperType,
                                                      @RequestParam(name = "feeSubType", required = false) String feeSubType,
                                                      @RequestParam(name = "companyValue", required = false) Integer companyValue,
                                                      @RequestParam(name = "companyName", required = false) String companyName,
                                                      @RequestParam(name = "departmentName", required = false) String departmentName,
                                                      @RequestParam(name = "createUserId", required = false) Integer createUserId,
                                                      @RequestParam(name = "payUserId", required = false) Integer payUserId);

    @GetMapping("/balanceSheetCost")
    CostResult<List<CostDto>> balanceSheetCostList(@RequestParam(name = "startDate") String startDateStr,
                                                   @RequestParam(name = "endDate") String endDateStr);

    @GetMapping("/noPayCost")
    CostResult<List<CostDto>> getNoPayCost(@RequestParam(name = "costNoList") List<String> costNoList);

    /**
     * 吴通新增
     * 根据费用单号获取费用单大类
     *
     * @param costNo 费用单号
     * @return 费用大类
     */
    @GetMapping("/type/{costNo}")
    CostResult<String> getTypeName(@PathVariable("costNo") String costNo);
}
