package com.blt.other.other_cost.dao;

import com.blt.other.other_database.model.CostTypeKindDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface CostTypeKindDao {

    /**
     * 获取所有费用种类
     *
     * @return
     */
    List<CostTypeKindDomain> selectAll();

    /**
     * 根据 typeNo 获取费用种类
     *
     * @param typeNo
     * @return
     */
    List<CostTypeKindDomain> selectByTypeNo(String typeNo);

    /**
     * 根据 companyNo 获取费用种类
     *
     * @param companyNo
     * @return
     */
    List<CostTypeKindDomain> selectByCompanyNo(String companyNo);

    /**
     * 根据 typeNo 和 kindName 获取费用种类，用于添加费用种类时判断是否已经存在相同的费用种类
     *
     * @param costTypeKindDomain
     * @return
     */
    CostTypeKindDomain selectByTypeNoAndKindName(CostTypeKindDomain costTypeKindDomain);

    /**
     * 根据 costTypeKindNo 获取种类信息
     *
     * @param costTypeKindNo
     * @return
     */
    CostTypeKindDomain selectByKindNo(String costTypeKindNo);

    /**
     * 根据费用小类名称和公司名称获取种类信息
     *
     * @param kindName
     * @param companyName
     * @return
     */
    @Deprecated
    CostTypeKindDomain selectByKindNameAndCompanyName(String kindName, String companyName);

    /**
     * <
     *
     * @param kindName
     * @param companyNo
     * @return
     */
    CostTypeKindDomain selectByKindNameAndCompanyNo(@Param("kindName") String kindName, @Param("companyNo") String companyNo);


    /**
     * 新增费用种类记录
     *
     * @param ctkd
     * @return
     */
    Integer insert(CostTypeKindDomain ctkd);

    List<CostTypeKindDomain> selectByCompanyNoAndCostForm(CostTypeKindDomain costTypeKindDomain);

    Integer update(CostTypeKindDomain costTypeKindDomain);

    Integer delete(String kindNo);

}
