package com.blt.other.module.cost.model;

import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.SpringContextUtil;
import com.bailuntec.cost.api.dto.CostAttach;
import com.bailuntec.cost.api.dto.CostDto;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.blt.other.common.util.CurUtils;
import com.blt.other.module.database.mapper.StatusMapper;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;

@Accessors(chain = true)
@TableName(value = "cost", autoResultMap = true)
@Data
public class CostDomain implements Serializable {

    //付款费用
    public final static Integer COST_FROM_1 = 1;
    //收款费用
    public final static Integer COST_FROM_2 = 2;
    //借支/借还
    public final static Integer COST_FROM_3 = 2;

    // 0 待提交 1- 待财务审核 2待出纳付款 3被驳回 4已支付 5已作废  6-待部门审核 7-待财务审核 8-待最终审核人审核
    public final static int STATUS_UN_SUBMIT = 0;

    public final static int STATUS_DEPARTMENT_CHECK = 6;
    public final static int STATUS_FINANCIAL_CHECK = 7;
    public final static int STATUS_FINAL_CHECK = 8;

    public final static int STATUS_UN_PAY = 2;
    public final static int STATUS_PAYED = 4;

    // 费用单编号
    @TableId(type = IdType.AUTO)
    private Integer id;
    // 费用单编号
    @ApiModelProperty("费用单编号")
    private String costNo;
    // 费用计划编号
    @ApiModelProperty("费用计划编号")
    private String costPlanNo;
    // 主体编号
    @ApiModelProperty("主体编号")
    private String companyNo;
    // 主体名称
    @ApiModelProperty("主体名称")
    private String companyName;
    // 类型编号
    @ApiModelProperty("类型编号")
    private String typeNo;
    // 类型标题
    @ApiModelProperty("类型标题")
    private String typeName;
    // 科目编号
    @ApiModelProperty("科目编号")
    private String subjectCode;
    // 小类编号
    @ApiModelProperty("小类编号")
    private String kindNo;
    // 小类标题
    @ApiModelProperty("小类标题")
    private String kindName;
    // 创建人 id
    @ApiModelProperty("创建人id")
    private Integer createUserid;
    // 创建人编号
    @ApiModelProperty("创建人编号")
    private String createUsercode;
    // 创建人名称
    @ApiModelProperty("创建人名称")
    private String createUsername;
    // 费用单备注
    @ApiModelProperty("费用单备注")
    private String costRemark;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    // 关联子单
    @ApiModelProperty("关联子单")
    @Deprecated
    private String sonCostNo;

    @ApiModelProperty("关联父单")
    private String supCostNo;

    @ApiModelProperty("费用单状态 0 待提交 1- 待财务审核 2待出纳付款 3被驳回 4已支付 5已作废  6-待部门审核 7-待财务审核 8-待最终审核人审核")
    private Integer costStatus;

    @ApiModelProperty("文件地址")
    private String filePath;

    @ApiModelProperty("补充材料地址")
    private String morFilePath;
    // 费用总金额
    @ApiModelProperty("费用总金额")
    private BigDecimal amount;
    // 二级物流供应商ID
    @ApiModelProperty("二级物流供应商ID")
    private Integer subLogisticsSupplierId;
    // 一级物流供应商ID
    @ApiModelProperty("一级物流供应商ID")
    private Integer logisticsSupplierId;
    // 收款银行（平台）
    @ApiModelProperty("收款银行（平台）")
    private String bankName;
    // 收款账户
    @ApiModelProperty("收款账户")
    private String bankCard;
    // 收款用户名
    @ApiModelProperty("收款用户名")
    private String bankCardUser;
    // 收款/付款单位
    @ApiModelProperty("收款/付款单位")
    private String bankCompany;
    // 补充信息
    @ApiModelProperty("补充信息")
    private String morRemark;

    // 1 付款费用 2 收款费用 3 借支/借还
    @ApiModelProperty("1 付款费用 2 收款费用 3 借支/借还")
    private Integer costForm;
    // 付款理由
    @ApiModelProperty("付款理由")
    private String costReason;
    // 1 借支 2 借还
    @ApiModelProperty("1 借支 2 借还")
    private Integer isLend;
    // 借支单已还金额
    @ApiModelProperty("借支单已还金额")
    private BigDecimal hadPay;

    // 借支单状态 1 未还 2 部分还款  3 结清
    @ApiModelProperty("借支单状态 1 未还 2 部分还款  3 结清")
    private Integer lendStatus;
    // 借支单补偿金额
    @ApiModelProperty("借支单补偿金额")
    private BigDecimal compensate;
    // 冲销金额
    @ApiModelProperty("冲销金额")
    private BigDecimal counteract;
    // 借还单余额
    @ApiModelProperty("借还单余额")
    private BigDecimal lendBalance;
    // 驳回原因
    @ApiModelProperty("驳回原因")
    private String rejectReason;
    // 币种
    @ApiModelProperty("币种")
    private String dic;
    // 借还单冲销金额 ( 支付币种 )
    @ApiModelProperty("借还单冲销金额 ( 支付币种 )")
    private BigDecimal payCounteract;
    // 借还单余额 （ 支付币种 ）
    @ApiModelProperty("借还单余额 （ 支付币种 ）")
    private BigDecimal payLendBalance;

    // 计划金额 （ 支付币种 ）
    @ApiModelProperty("计划金额 （ 支付币种 ）")
    private BigDecimal payPlanAmount;
    // 支付币种
    @ApiModelProperty("支付币种")
    private String payDic;
    // 汇率
    @ApiModelProperty("汇率")
    private BigDecimal payCur;
    // 0 不抵扣个税  1 抵扣个税
    @ApiModelProperty("0 不抵扣个税  1 抵扣个税")
    private Integer isTax;
    // 出纳系统 detailKey
    @ApiModelProperty("出纳系统 detailKey")
    private String detailKey;
    // 支付者用户ID
    @ApiModelProperty("支付者用户ID")
    private Integer payUserId;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    // 支付时间
    @ApiModelProperty("支付时间")
    private Date payTime;
    // 转人民币汇率
    @ApiModelProperty("转人民币汇率")
    private BigDecimal toRmbRate;
    // 费用单人民币总金额
    @ApiModelProperty("费用单人民币总金额")
    private BigDecimal amountRmb;
    // 公司主体value
    @ApiModelProperty("公司主体value")
    private Integer companyValue;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("财务审核时间")
    private Date auditTime;
    //发票状态
    @ApiModelProperty("费用单发票状态编号")
    private Integer hasInvoice;
    //驳回类型
    @ApiModelProperty("驳回类型")
    private Integer rejectType;
    //财务驳回时间
    @ApiModelProperty("财务驳回时间")
    private Date rejectTime;

    @ApiModelProperty("")
    private String cashierFilePath;

    @ApiModelProperty("")
    private String cashierDownloadPath;

    //
    @ApiModelProperty("费用来源 1-默认 2-WMS 3-调拨系统")
    private String sourceFrom;
    //项目
    @ApiModelProperty("项目")
    private String projectType;
    //客户编号
    @ApiModelProperty("客户编号")
    private String customerNum;

    @TableField(typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty("附加字段")
    private List<CostAttach> attach;

    @ApiModelProperty("费用模版id")
    private Integer costTemplateId;

    @TableField(exist = false)
    private CostTemplate costTemplate;

    public CostDto castToDto() {

        StatusMapper statusMapper = SpringContextUtil.getBean(StatusMapper.class);

        CostDto costDto = new CostDto();
        BeanUtils.copyProperties(this, costDto);

        /*字典翻译*/
        costDto.setCostStatusDto(statusMapper.getStatusValue("cost_status", this.getCostStatus()));
        if (null != this.getIsLend() && !"null".equals(this.getIsLend())) {
            costDto.setIsLendDto(statusMapper.getStatusValue("is_lend", this.getIsLend()));
        }
        if (null != this.getCostForm() && !"null".equals(this.getCostForm())) {
            costDto.setCostFormDto(statusMapper.getStatusValue("cost_form", this.getCostForm()));
        }
        if (null != this.getLendStatus() && !"null".equals(this.getLendStatus())) {
            costDto.setLendStatusDto(statusMapper.getStatusValue("lend_status", this.getLendStatus()));
        }
        // 获取文件名
        String filePath = this.getFilePath();
        if (null != filePath && filePath.contains("&")) {
            costDto.setFileName(filePath.substring(filePath.lastIndexOf("&") + 1));
        }
        // 抵个税
        if (1 == costDto.getCostForm()) {
            costDto.setIsTaxStr(statusMapper.getStatusValue("is_tax", costDto.getIsTax()));
        }
        // 币种
        costDto.setDicDto(CurUtils.getCurDto(costDto.getDic()));
        costDto.setPayDicDto(CurUtils.getCurDto(costDto.getPayDic()));
//
        DecimalFormat df = new DecimalFormat("#0.00");
        if (null != costDto.getAmount()) {
            String format = df.format(costDto.getAmount());
            costDto.setAmountDto(format);
        }
        if (null != costDto.getPayPlanAmount()) {
            String format = df.format(costDto.getPayPlanAmount());
            costDto.setPayPlanAmountDto(format);
        }
        return costDto;
    }

}

