package com.blt.other.module.sys.controller;


import com.bailuntec.cost.api.response.CostResult;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.module.auth.service.IOaDepartmentService;
import com.blt.other.module.cost.service.CostCompanyService;
import com.blt.other.module.sys.dto.request.CompanyReviewerListReq;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-10-13
 */
@Api(tags = "审核人接口")
@RestController
@RequestMapping("/costReviewer")
public class CostReviewerController {
    @Resource
    CostCompanyService costCompanyService;


    /*财务审核设置 start*/
    @ApiOperation("获取财务审核人、最终审核人呢、行政审核人配置列表")
    @GetMapping("/companyReviewerList")
    public CostResult<IPage<CostCompanyDomain>> companyReviewerList(CompanyReviewerListReq req) {
        IPage<CostCompanyDomain> costCompanyDomainIPage = costCompanyService.reviewerList(req);
        return CostResult.success(costCompanyDomainIPage);
    }

    @ApiOperation("/修改财务审核人")
    @GetMapping("/modifyFinancialReviewer")
    public CostResult<Void> modifyFinancialReviewer(@RequestParam Integer userId,
                                                    @RequestParam @ApiParam("财务公司主体 逗号分隔") List<String> companyNoList,
                                                    @RequestParam @ApiParam("oa用户id 逗号分隔") List<Integer> financialReviewerUserIdList) {
        costCompanyService.modifyFinancialReviewer(userId, companyNoList, financialReviewerUserIdList);
        return CostResult.success();
    }
    /*财务审核设置 end*/

    @ApiOperation("/修改最终审核人")
    @GetMapping("/modifyFinalReviewer")
    public CostResult<Void> modifyFinalReviewer(@RequestParam Integer userId,
                                                @RequestParam @ApiParam("财务公司主体 逗号分隔") List<String> companyNoList,
                                                @RequestParam @ApiParam("oa用户id 逗号分隔") Integer finalReviewerUserId) {
        costCompanyService.modifyFinalReviewer(userId, companyNoList, finalReviewerUserId);
        return CostResult.success();
    }


    @ApiOperation("/修改行政审核")
    @GetMapping("/modifyHrReviewer")
    public CostResult<Void> modifyHrReviewer(@RequestParam Integer userId,
                                             @RequestParam @ApiParam("财务公司主体 逗号分隔") List<String> companyNoList,
                                             @RequestParam @ApiParam("oa用户id 逗号分隔") List<Integer> hrReviewerUserIdList) {
        costCompanyService.modifyHrReviewer(userId, companyNoList, hrReviewerUserIdList);
        return CostResult.success();
    }


}
