package com.blt.other.other_entrepot.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_database.model.InventoryDomain;
import com.blt.other.other_entrepot.service.InventorySearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("inventory/search")
public class InventorySearchController {

    @Autowired
    private InventorySearchService inventorySearchService;

    @PostMapping("")
    public Map<String,Object> key(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String searchKey = request.getParameter("searchKey");
        List<InventoryDomain> byKey = inventorySearchService.getByKey(searchKey);
        Map<String,Object> result = new HashMap<>();
        result.put("inventories",byKey);
        result.put("success",true);
        return result;
    }
}
