package com.blt.other.module.cost.controller.costtemplate;


import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.module.cost.dto.CostTemplateColApiReq;
import com.blt.other.module.cost.model.CostTemplateCol;
import com.blt.other.module.cost.service.ICostTemplateColService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 费用单模版 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Api(tags = "费用单模版字段接口")
@RestController
@RequestMapping("/costTemplateCol")
public class CostTemplateColController {

    @Resource
    ICostTemplateColService costTemplateColService;

    @ApiOperation("/新增费用单模版字段")
    @PostMapping("/add")
    public CostResult<Void> add(@RequestBody CostTemplateCol costTemplateCol) {
        costTemplateColService.add(costTemplateCol);
        return CostResult.success();
    }

    @ApiOperation("/更新费用单模版字段")
    @PostMapping("/modify")
    public CostResult<Void> modify(@RequestBody CostTemplateCol costTemplateCol) {
        costTemplateColService.modify(costTemplateCol);
        return CostResult.success();
    }

    @ApiOperation("/删除费用单模版字段")
    @PostMapping("/delete")
    public CostResult<Void> add(@RequestParam Integer id) {
        costTemplateColService.delete(id);
        return CostResult.success();
    }

    @ApiOperation("/筛选费用单模版字段")
    @PostMapping("/queryList")
    public CostResult<List<CostTemplateCol>> queryList(@RequestBody CostTemplateColApiReq.QueryListReq req) {
        List<CostTemplateCol> resp = costTemplateColService.queryList(req);
        return CostResult.success(resp);
    }

}
