package com.blt.other.other_cost.utils;

import com.blt.other.other_database.model.CostPlanDomain;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 费用工具类
 */
public class CostPlanUtils {

    /**
     * 生成 CostPlanDomain 实例
     * @param request
     * @return
     */
    public static CostPlanDomain createCostPlan(HttpServletRequest request, String planNo){
        String companyNo = request.getParameter("companyNo");
        String kindNo = request.getParameter("kindNo");
        String amountRequest = request.getParameter("planAmount");
        BigDecimal playAmount = null;
        if (null != amountRequest) {
            playAmount = new BigDecimal(amountRequest);
        }
        String createUsercode = request.getParameter("createUsercode");
        String bankName = request.getParameter("bankName");
        String bankCard = request.getParameter("bankCard");
        String bankCardUser = request.getParameter("bankCardUser");
        String bankCompany = request.getParameter("bankCompany");
        String costReason = request.getParameter("costReason");
        String costRemark = request.getParameter("costRemark");
        String isLendStr = request.getParameter("isLend");
        String dic = request.getParameter("dic");
        Integer isLend = null;
        if (null != isLendStr && !"null".equals(isLendStr)){
            isLend = Integer.parseInt(isLendStr);
        }
        String costFormStr = request.getParameter("costForm");
        Integer costForm = null;
        if (null != costFormStr && !"null".equals(costFormStr)){
            costForm = Integer.parseInt(costFormStr);
        }

        // 封装 CostDomain
        CostPlanDomain costPlanDomain = new CostPlanDomain();
        costPlanDomain.setCostPlanNo(planNo);
        costPlanDomain.setCompanyNo(companyNo);
        costPlanDomain.setKindNo(kindNo);
        costPlanDomain.setPlanAmount(playAmount);
        costPlanDomain.setCreateUsercode(createUsercode);
        costPlanDomain.setBankName(bankName);
        costPlanDomain.setBankCard(bankCard);
        costPlanDomain.setBankCardUser(bankCardUser);
        costPlanDomain.setBankCompany(bankCompany);
        costPlanDomain.setCostForm(costForm);
        costPlanDomain.setCostReason(costReason);
        costPlanDomain.setCostRemark(costRemark);
        costPlanDomain.setIsLend(isLend);
        costPlanDomain.setCreateTime(new Date());
        costPlanDomain.setDic(dic);
        if (null != costForm && 3 == costForm){
            if (1 == isLend){
                // 借支
                costPlanDomain.setTypeNo(null);
                costPlanDomain.setKindNo(kindNo);
                String lendStatus = request.getParameter("lendStatus");
                if (null != lendStatus && !"null".equals(lendStatus)) {
                    costPlanDomain.setLendStatus(Integer.parseInt(lendStatus));
                }
                String hadPay = request.getParameter("hadPay");
                if (null != hadPay && !"null".equals(hadPay)){
                    costPlanDomain.setHadPay(new BigDecimal(hadPay));
                }
                String compensate = request.getParameter("compensate");
                if (null != compensate && !"null".equals(compensate)) {
                    costPlanDomain.setCompensate(new BigDecimal(compensate));
                }
                String counteract = request.getParameter("counteract");
                if (null != counteract && !"null".equals(counteract)) {
                    costPlanDomain.setCounteract(new BigDecimal(counteract));
                }
                String lendBalance = request.getParameter("lendBalance");
                if (null != lendBalance && !"null".equals(lendBalance)) {
                    costPlanDomain.setLendBalance(new BigDecimal(lendBalance));
                }
            }else if (2 == isLend){
                // 借还
                String supCostNo = request.getParameter("supCostNo");
                costPlanDomain.setSupCostNo(supCostNo);
                costPlanDomain.setTypeNo(null);
                costPlanDomain.setKindNo(kindNo);
                String lendBalance = request.getParameter("lendBalance");
                if (null != lendBalance && !"null".equals(lendBalance)) {
                    costPlanDomain.setLendBalance(new BigDecimal(lendBalance));
                }
                String counteract = request.getParameter("counteract");
                if (null != counteract && !"null".equals(counteract)) {
                    costPlanDomain.setCounteract(new BigDecimal(counteract));
                }

                String payDic = request.getParameter("payDic");
                if (null != lendBalance && !"null".equals(lendBalance)) {
                    costPlanDomain.setPayDic(payDic);
                }
                String payCounteract = request.getParameter("payCounteract");
                payCounteract = payCounteract.replace(" ","");
                if (null != payCounteract && (!"null".equals(payCounteract) && !payCounteract.isEmpty())) {
                    costPlanDomain.setPayCounteract(new BigDecimal(payCounteract));
                }else {
                    costPlanDomain.setPayCounteract(new BigDecimal(0));
                }
                String payLendBalance = request.getParameter("payLendBalance");
                payLendBalance = payLendBalance.replace(" ","");
                if (null != payLendBalance && (!"null".equals(payLendBalance) && !payLendBalance.isEmpty())) {
                    costPlanDomain.setPayLendBalance(new BigDecimal(payLendBalance));
                }else {
                    costPlanDomain.setPayLendBalance(new BigDecimal(0));
                }
                String payPlanAmount = request.getParameter("payPlanAmount");
                if (null != payPlanAmount && !"null".equals(payPlanAmount)) {
                    costPlanDomain.setPayPlanAmount(new BigDecimal(payPlanAmount));
                }
                String cur = request.getParameter("cur");
                if (null != cur && !"null".equals(cur)) {
                    costPlanDomain.setPayCur(new BigDecimal(cur));
                }
            }
        }
        return costPlanDomain;
    }
}
