package com.blt.other;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.bailuntec.api.bailuntec.oa.OaApi;
import com.bailuntec.api.bailuntec.oa.response.OaDepartmentResp;
import com.bailuntec.api.bailuntec.oa.response.OaUserResp;
import com.bailuntec.common.SpringContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaDepartment;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.auth.service.IOaDepartmentService;
import com.blt.other.module.auth.service.IOaUserService;
import com.blt.other.module.cost.dao.*;
import com.blt.other.module.cost.model.AccountingSubject;
import com.blt.other.module.cost.model.CostCurrentReviewer;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.sys.dao.DepartmentReviewerMapper;
import com.blt.other.module.sys.model.CostReviewer;
import com.blt.other.module.sys.model.DepartmentReviewer;
import lombok.Data;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Transactional
@RunWith(SpringRunner.class)
@SpringBootTest(classes = OtherApplication.class)
@ActiveProfiles("prod")
public class OtherApplicationTests {

    @Autowired
    private OaApi oaApi;
    @Autowired
    private IOaUserService oaUserService;
    @Autowired
    private IOaDepartmentService oaDepartmentService;
    @Resource
    OaDepartmentMapper oaDepartmentMapper;
    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    DepartmentReviewerMapper departmentReviewerMapper;

    @Rollback(value = false)
    @Test
    public void syncDepartmentReviewer() {
        departmentReviewerMapper.delete(new LambdaQueryWrapper<>());

        List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                .eq(CostReviewer::getType, 1));

        costReviewerList.stream().collect(Collectors.groupingBy(CostReviewer::getReferId))
                .forEach((departmentId, list) -> {

                    OaDepartment oaDepartment = oaDepartmentMapper.selectByDepartmentId(departmentId);
                    DepartmentReviewer departmentReviewer = new DepartmentReviewer();
                    departmentReviewer.setPrimaryDepartmentId(oaDepartment.getDepartmentId());
                    departmentReviewer.setAutoReviewAmount(oaDepartment.getDepartmentMinimumReviewAmount());
                    departmentReviewer.setPrimaryDepartmentName(oaDepartment.getName());

                    departmentReviewer.setSecondDepartmentId(0);
                    departmentReviewer.setSecondDepartmentName("全部");
                    departmentReviewer.setCreateTime(LocalDateTime.now());
                    departmentReviewer.setLastUpdateTime(LocalDateTime.now());

                    departmentReviewerMapper.insert(departmentReviewer);

                    list.forEach(costReviewer -> {
                        costReviewer.setReferId(departmentReviewer.getId());
                        costReviewer.setType(CostReviewer.departmentReviewer);
                        costReviewer.setId(null);
                        costReviewerMapper.insert(costReviewer);
                    });

                });
        costReviewerList.forEach(costReviewer -> {


        });
    }

    @Rollback(value = false)
    @Test
    public void syncOa() {
        List<OaUserResp> oaUserRespList = oaApi.getAllUser();
        List<OaDepartmentResp> oaDepartmentRespList = oaApi.getDeparmentList();

        List<OaUser> oaUserList = oaUserRespList.stream().map(oaUserResp -> {
            OaUser oaUser = new OaUser();
            oaUser.setCompanyId(oaUserResp.getCompanyId());
            oaUser.setDepartmentId(oaUserResp.getDepartmentId());
            oaUser.setOaUserId(oaUserResp.getId());
            oaUser.setUserAccount(oaUserResp.getUserAccount());
            oaUser.setUserCode(oaUserResp.getUserCode());
            oaUser.setUserName(oaUserResp.getUserName());
            return oaUser;
        })
                .collect(Collectors.toList());


        List<OaDepartment> oaDepartmentList = oaDepartmentRespList.stream().map(oaDepartmentResp -> {
            OaDepartment oaDepartment = new OaDepartment();
            oaDepartment.setCode(oaDepartmentResp.getCode());
            oaDepartment.setCompanyId(oaDepartmentResp.getCompanyId());
            oaDepartment.setManageUser1(oaDepartmentResp.getManageUser1());
            oaDepartment.setManageUser2(oaDepartmentResp.getManageUser2());
            oaDepartment.setName(oaDepartmentResp.getName());
            oaDepartment.setSort(oaDepartmentResp.getSort());
            oaDepartment.setParentId(oaDepartmentResp.getParentId());
            oaDepartment.setDepartmentId(oaDepartmentResp.getDepartmentId());
            oaDepartment.setFullName(oaDepartmentResp.getFullName());
            return oaDepartment;
        })
                .collect(Collectors.toList());

        Map<Integer, OaDepartment> oaDepartmentMap = oaDepartmentList.stream().collect(Collectors.toMap(
                OaDepartment::getDepartmentId, oaDepartment -> oaDepartment, (k1, k2) -> k1
        ));
        oaUserList.forEach(oaUser -> {
            oaUser.setPrimaryDepartmentId(this.getPrimaryDepartment(oaDepartmentMap, oaDepartmentMap.get(oaUser.getDepartmentId())).getDepartmentId());
            if (oaUserService.getOne(new LambdaQueryWrapper<OaUser>().eq(OaUser::getOaUserId, oaUser.getOaUserId())) == null) {
                oaUserService.save(oaUser);
            }
        });

        oaDepartmentList.forEach(oaDepartment -> {
            if (oaDepartmentMapper.selectByDepartmentId(oaDepartment.getDepartmentId()) == null) {
                oaDepartment.setUpdateUserId(0);
                oaDepartmentService.save(oaDepartment);
            } else {
                oaDepartmentService.update(oaDepartment, new LambdaQueryWrapper<OaDepartment>()
                        .eq(OaDepartment::getDepartmentId, oaDepartment.getDepartmentId()));
            }
        });

    }

    private OaDepartment getPrimaryDepartment(Map<Integer, OaDepartment> departmentMap, OaDepartment oaDepartment) {
        if (oaDepartment == null) {
            return new OaDepartment();
        }
        if (oaDepartment.getParentId().equals(0) || oaDepartment.getParentId() == null) {
            return oaDepartment;
        }
        return getPrimaryDepartment(departmentMap, departmentMap.get(oaDepartment.getParentId()));
    }


    @Rollback(value = false)
    @Test
    public void importMallProduct() {
        TypeListener typeListener = new TypeListener();
        EasyExcel.read("/Users/huluobin/费用类型.xlsx", TypeItem.class, typeListener).sheet().doRead();

    }


    @Data
    public static class TypeItem {

        @ExcelProperty("desc")
        private String desc;

        @ExcelProperty("type")
        private String type;

        @ExcelProperty(value = "account_type")
        private String accountType;

        @ExcelProperty(value = "cost_type")
        private Integer costType;

    }

    public static class TypeListener extends AnalysisEventListener<TypeItem> {


        private static final Logger LOGGER = LoggerFactory.getLogger(TypeListener.class);

        TypeListener() {

        }

        private static final int BATCH_COUNT = 2000;
        List<TypeItem> list = new ArrayList<>();

        @Override
        public void invoke(TypeItem data, AnalysisContext context) {
            LOGGER.info("解析到一条数据:{}", JSON.toJSONString(data));
            list.add(data);
            if (list.size() >= BATCH_COUNT) {
                syncData();
                list.clear();
            }
        }

        @Override
        public void doAfterAllAnalysed(AnalysisContext context) {
            syncData();
            LOGGER.info("所有数据解析完成！");
        }

        private void syncData() {

            Map<Integer, Integer> map = new HashMap<>();
            map.put(1, CostTypeDomain.feeType);
            map.put(2, CostTypeDomain.incomeType);
            map.put(3, CostTypeDomain.borrow);

            list.forEach(item -> {
                AccountingSubjectMapper accountingSubjectMapper = SpringContextUtil.getBean(AccountingSubjectMapper.class);
                AccountingSubject accountingSubject = accountingSubjectMapper.selectByName(item.getAccountType());
                if (accountingSubject == null) {
                    accountingSubject = new AccountingSubject();
                    accountingSubject.setName(item.getAccountType());
                    accountingSubject.setSubjectNo(IdWorker.getIdStr());
                    accountingSubjectMapper.insert(accountingSubject);
                }
                CostTypeDao costTypeDao = SpringContextUtil.getBean(CostTypeDao.class);

                CostTypeDomain costTypeDomain = costTypeDao.selectOne(new LambdaQueryWrapper<CostTypeDomain>()
                        .eq(CostTypeDomain::getTypeName, item.getType())
                        .eq(CostTypeDomain::getCostTemplateType, map.get(item.getCostType()))
                        .eq(CostTypeDomain::getAccountingSubjectNo, accountingSubject.getSubjectNo()));

                if (costTypeDomain == null) {
                    costTypeDomain = new CostTypeDomain();
                }

                costTypeDomain.setCostTemplateType(map.get(item.getCostType()));
                costTypeDomain.setTypeName(item.getType());
                costTypeDomain.setTypeNo(IdWorker.getIdStr());
                costTypeDomain.setDescription(item.getDesc());
                costTypeDomain.setAccountingSubjectNo(accountingSubject.getSubjectNo());

                boolean b = costTypeDao.updateById(costTypeDomain) > 0 || costTypeDao.insert(costTypeDomain) > 0;

            });
        }
    }

    @Resource
    CostDao costDao;
    @Resource
    CostCurrentReviewerMapper costCurrentReviewerMapper;
    @Resource
    CostCompanyDao costCompanyDao;
    @Resource
    OaUserMapper oaUserMapper;

    @Test
    @Rollback(value = false)
    public void syncOldCost() {
        List<CostDomain> costDomains1 = costDao.selectByStatus(CostDomain.STATUS_DEPARTMENT_CHECK);

        costDomains1.forEach(costDomain -> {

            OaUser oaUser = oaUserMapper.selectByOaUserId(costDomain.getCreateUserid());
            List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, 1)
                    .eq(CostReviewer::getReferId, oaUser.getPrimaryDepartmentId()));

            costReviewerList.forEach(costReviewer -> {
                CostCurrentReviewer costCurrentReviewer = new CostCurrentReviewer();
                costCurrentReviewer.setUsername(costReviewer.getReviewerUserName());
                costCurrentReviewer.setOaUserId(costReviewer.getReviewerUserId());
                costCurrentReviewer.setCostNo(costDomain.getCostNo());
                costCurrentReviewerMapper.insert(costCurrentReviewer);
            });
        });

        List<CostDomain> costDomains2 = costDao.selectByStatus(CostDomain.STATUS_FINANCIAL_CHECK);

        costDomains2.forEach(costDomain -> {
            CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(costDomain.getCompanyNo());

            List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.financialReviewer)
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId()));

            costReviewerList.forEach(costReviewer -> {
                CostCurrentReviewer costCurrentReviewer = new CostCurrentReviewer();
                costCurrentReviewer.setUsername(costReviewer.getReviewerUserName());
                costCurrentReviewer.setOaUserId(costReviewer.getReviewerUserId());
                costCurrentReviewer.setCostNo(costDomain.getCostNo());
                costCurrentReviewerMapper.insert(costCurrentReviewer);
            });
        });

        List<CostDomain> costDomains3 = costDao.selectByStatus(CostDomain.STATUS_HR_CHECK);

        costDomains3.forEach(costDomain -> {
            CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(costDomain.getCompanyNo());

            List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.hrReviewer)
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId()));

            costReviewerList.forEach(costReviewer -> {
                CostCurrentReviewer costCurrentReviewer = new CostCurrentReviewer();
                costCurrentReviewer.setUsername(costReviewer.getReviewerUserName());
                costCurrentReviewer.setOaUserId(costReviewer.getReviewerUserId());
                costCurrentReviewer.setCostNo(costDomain.getCostNo());
                costCurrentReviewerMapper.insert(costCurrentReviewer);
            });
        });

        List<CostDomain> costDomains4 = costDao.selectByStatus(CostDomain.STATUS_FINAL_CHECK);

        costDomains4.forEach(costDomain -> {
            CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(costDomain.getCompanyNo());

            List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.finalReviewer)
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId()));

            costReviewerList.forEach(costReviewer -> {
                CostCurrentReviewer costCurrentReviewer = new CostCurrentReviewer();
                costCurrentReviewer.setUsername(costReviewer.getReviewerUserName());
                costCurrentReviewer.setOaUserId(costReviewer.getReviewerUserId());
                costCurrentReviewer.setCostNo(costDomain.getCostNo());
                costCurrentReviewerMapper.insert(costCurrentReviewer);
            });
        });
    }

}

