package com.blt.other.other_entrepot.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_commons.utils.MyMapperUtil;
import com.blt.other.other_database.model.WarehouseDomain;
import com.blt.other.other_entrepot.service.WarehouseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

@RestController
@RequestMapping("/warehouse")
public class WarehouseController {
    @Autowired
    private WarehouseService warehouseService;

    @PostMapping("/save")
    public Map<String,Object> save(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = null;
        Enumeration<String> params = request.getParameterNames();
        if (null != params && params.hasMoreElements()){
            String s = params.nextElement();
            WarehouseDomain warehouse = (WarehouseDomain)MyMapperUtil.getObject(s, WarehouseDomain.class);
            // 判断是否已经存在该仓库（仓库名判断）
            WarehouseDomain warehouseDomain = warehouseService.getByWarehousename(warehouse.getWarehousename());
            if (null != warehouseDomain && !warehouseDomain.getWarehousename().isEmpty()){
                result = new HashMap<>();
                result.put("success", false);
                result.put("msg","仓库已存在");
                return result;
            }
            warehouse.setWarehouseid(warehouseService.createWarehouseid());
            warehouse.setCreateTime(new Date());
            warehouse.setIsStative(0);
            Integer insert = warehouseService.insert(warehouse);
            if (null != insert && insert == 1) {
                result = new HashMap<>();
                result.put("success", true);
                result.put("warehouse",warehouse);
                result.put("msg","已保存");
            }
        }
        return result;
    }

    @GetMapping("/getWarehouseList")
    public Map<String,Object> getWarehouseList(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();
        List<WarehouseDomain> list = warehouseService.getWarehouseList();
        result.put("success",true);
        result.put("msg","");
        result.put("warehouses",list);
        return result;
    }

    @PostMapping("/getWarehouse")
    public Map<String,Object> getWarehouse(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();
        String warehouseid = request.getParameter("warehouseid");
        WarehouseDomain warehouse = warehouseService.getByWarehosueid(warehouseid);
        result.put("success",true);
        result.put("msg","");
        result.put("warehouse",warehouse);
        return result;
    }

    @PostMapping("/update")
    public Map<String,Object> update(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = null;
        String warehouseid = request.getParameter("warehouseid");
        String warehousename = request.getParameter("warehousename");
        String isStativeStr = request.getParameter("isStative");
        WarehouseDomain warehouse = new WarehouseDomain();
        warehouse.setWarehouseid(warehouseid);
        warehouse.setWarehousename(warehousename);
        warehouse.setIsStative(Integer.parseInt(isStativeStr));
        Integer update = warehouseService.update(warehouse);
        if (null != update && update == 1){
            result = new HashMap<>();
            result.put("success",true);
            result.put("msg","");
        } else {
            result = new HashMap<>();
            result.put("success",false);
            result.put("msg","更新失败，请稍后重试");
        }
        return result;
    }
}
