package com.blt.other.other_cost.service.impl;

import com.blt.other.other_commons.utils.CurUtils;
import com.blt.other.other_cost.dao.CostListSearchDao;
import com.blt.other.other_cost.dto.CostDto;
import com.blt.other.other_cost.service.CostListSearchService;
import com.blt.other.other_cost.service.CostService;
import com.blt.other.other_cost.vo.CostListSearchKeysVo;
import com.blt.other.other_database.mapper.StatusMapper;
import com.blt.other.other_database.model.CostDomain;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import org.apache.commons.collections.ListUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class CostListSearchServiceImpl implements CostListSearchService {

    @Autowired
    private CostListSearchDao costListSearchDao;
    @Autowired
    private StatusMapper statusMapper;
    @Autowired
    private CostService costService;

    @Override
    public Map<String, Object> searchByKey(String key, int pageNum, int pageSize) {
        Map<String,Object> result = new HashMap<>();
        PageHelper.startPage(pageNum,pageSize);
        List<CostDomain> costDomains = costListSearchDao.selectByKey(Lists.newArrayList(key.split(",")).stream().filter(Objects::nonNull).collect(Collectors.toList()));
        List<CostDto> dtos = domainListToDto(costDomains);
        PageInfo<CostDomain> pageInfo = new PageInfo<>(costDomains);
        result.put("costs",dtos);
        result.put("pageInfo",pageInfo);
        return result;
    }

    /**
     * 实体类转化
     * @param domains
     * @return
     */
    @Override
    public List<CostDto> domainListToDto(List<CostDomain> domains) {
        if (null != domains && domains.size() >= 1){
            List<CostDto> dtos = new ArrayList<>();
            for (CostDomain domain: domains){
                CostDto costDto = new CostDto();
                BeanUtils.copyProperties(domain,costDto);
                if (null != domain.getDic() && !domain.getDic().isEmpty()) {
                    costDto.setDicDto(CurUtils.getCurDto(domain.getDic()));
                }
                if (null != domain.getPayDic() && !domain.getPayDic().isEmpty()) {
                    costDto.setPayDicDto(CurUtils.getCurDto(domain.getPayDic()));
                }
                costDto.setCostStatusDto(statusMapper.getStatusValue("cost_status",domain.getCostStatus()));
                costDto.setCostFormDto(statusMapper.getStatusValue("cost_form",domain.getCostForm()));
                if (null != domain.getIsLend() && domain.getIsLend() > 0) {
                    costDto.setIsLendDto(statusMapper.getStatusValue("is_lend", domain.getIsLend()));
                }
                if (null != domain.getLendStatus()) {
                    costDto.setLendStatusDto(statusMapper.getStatusValue("lend_status", domain.getLendStatus()));
                }
                if (null != domain.getIsTax() && 1 == domain.getCostForm()) {
                    costDto.setIsTaxStr(statusMapper.getStatusValue("is_tax", domain.getIsTax()));
                }
                // 金额保留两位小数
                DecimalFormat df = new DecimalFormat("#0.00");
                if (null != costDto.getAmount()) {
                    String format = df.format(costDto.getAmount());
                    costDto.setAmountDto(format);
                }
                if (null != costDto.getPayPlanAmount()){
                    String format = df.format(costDto.getPayPlanAmount());
                    costDto.setPayPlanAmountDto(format);
                }
                dtos.add(costDto);
            }
            return dtos;
        }
        return null;
    }

    @Override
    public Map<String, Object> searchByKeys(CostListSearchKeysVo searchKeysVo) {
        Map<String, Object> result = new HashMap<>();
        PageHelper.startPage(searchKeysVo.getParams().getPageNum(),searchKeysVo.getParams().getPageSize());
        List<CostDomain> domains = costListSearchDao.selectByKeys(searchKeysVo);
        PageInfo<CostDomain> pageInfo = new PageInfo<>(domains);
        if (null != searchKeysVo.getParams().getKeys().getLinkCost() && !searchKeysVo.getParams().getKeys().getLinkCost().isEmpty()){
            List<CostDomain> list = new ArrayList<>();
            CostDomain supCost = costService.getCostDomainByNo(searchKeysVo.getParams().getKeys().getLinkCost());
            list.add(supCost);
            if (null != domains && domains.size() >= 1){
                for (CostDomain cost: domains){
                    list.add(cost);
                }
            }
            result.put("costs",domainListToDto(list));
        }else {
            result.put("costs", domainListToDto(domains));
        }
        result.put("pageInfo",pageInfo);
        return result;
    }

    @Override
    public List<CostDomain> getLinkCost() {
        return costListSearchDao.selectLinkList();
    }
}
