package com.blt.other.module.cost.service.impl.costcheck;

import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.auth.model.CostReviewer;
import com.blt.other.module.auth.service.IOaUserService;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.database.model.CostCompanyDomain;
import com.blt.other.module.database.model.CostLogDomain;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/30 2:57 下午
 */
@Component
public class FinancialCheckState extends CostState {


    @Resource
    FinalCheckState finalCheckState;
    @Resource
    CostCompanyDao costCompanyDao;
    @Resource
    IOaUserService oaUserService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void handle() {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;
        CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_FINANCIAL_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //需要自动审核
        if (costTemplate.shouldFinancialAutoCheck()) {
            //自动审核通过
            if (this.autoCheck(costDomain)) {
                costDomain.setCostStatus(CostDomain.STATUS_FINAL_CHECK);
                costDao.updateById(costDomain);
                costLogService.saveByManage(costDomain.getCostNo(), "财务自动审核通过", CostLogDomain.FINANCIAL_AUTO_PASS);

                //流转状态
                nextState(finalCheckState);
                //发布到总线尝试下个环节的自动审核
                costSubscribe.subscribe(costContext);
                return;
            }

        }

        CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());
        if (costContext.currentUserId != null) {
            //人工审核通过
            if (costReviewerMapper.queryOne(costCompany.getId(), CostReviewer.financialReviewer, currentUserId) != null) {
                costDomain.setCostStatus(CostDomain.STATUS_FINAL_CHECK);
                costDao.updateById(costDomain);

                costLogService.save(costDomain.getCostNo(), currentUserId, "财务审核通过", CostLogDomain.FINANCIAL_MANUAL_PASS);

                //流转状态
                nextState(finalCheckState);
                //发布到总线尝试下个环节的自动审核
                costSubscribe.subscribe(costContext);
            }
            //人工审核没权限
            else {
                throw new BizRuntimeException("current user no authority");
            }
        }
    }

    @Override
    public void refuse(String rejectReason) {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;

        CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_FINANCIAL_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //人工审核通过
        if (costReviewerMapper.queryOne(costCompany.getId(), CostReviewer.financialReviewer, currentUserId) == null) {
            throw new BizRuntimeException("current user no authority");
        }

        costContext.costService.resetCost(costDomain.getCostNo());

        costLogService.save(costDomain.getCostNo(), currentUserId, "财务审核拒绝,理由:" + rejectReason, CostLogDomain.TYPE_UPDATE);

    }
}
