package com.blt.other.module.purchasing.controller;

import com.blt.other.module.database.model.BuyDomain;
import com.blt.other.module.purchasing.service.BuyApiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@RestController
@RequestMapping("/buy/api")
public class BuyApiController {

    @Autowired
    private BuyApiService buyApiService;

    private static Logger logger = LoggerFactory.getLogger(BuyApiController.class);

    @GetMapping("/balanceSheetBuy")
    public Map<String, Object> balanceSheetBuyList(@RequestParam(name = "startDate") String startDateStr,
                                                    @RequestParam(name = "endDate") String endDateStr){
        logger.warn("获取资产负债表相关采购单");
        Map<String,Object> result = new HashMap<>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date startDate = sdf.parse(startDateStr);
            Date endDate = sdf.parse(endDateStr);
            List<BuyDomain> balanceSheetBuyList = buyApiService.getBalanceSheetBuy(startDate, endDate);
            result.put("success", true);
            result.put("data", balanceSheetBuyList);
        } catch (ParseException e){
            e.printStackTrace();
            result.put("success", false);
        }
        return result;
    }
}
