package com.blt.other.module.cost.service.impl.costtemplate;

import com.bailuntec.common.ListUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.cost.dao.CostTemplateColMapper;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.cost.model.CostTemplateCol;
import com.blt.other.module.cost.service.ICostTemplateBaseColService;
import com.blt.other.module.cost.service.ICostTemplateColService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 费用单模版 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Service
public class CostTemplateColServiceImpl extends ServiceImpl<CostTemplateColMapper, CostTemplateCol> implements ICostTemplateColService {


    @Resource
    ICostTemplateBaseColService costTemplateBaseColService;

    @Override
    public void delete(Integer id) {
        CostTemplateCol costTemplateCol = this.getById(id);
        if (costTemplateCol.getIsDefault()) {
            throw new BizRuntimeException("unable to remove default costTemplateCol");
        }
        this.removeById(id);
    }

    @Override
    public void modify(CostTemplateCol costTemplateCol) {
        if (costTemplateCol.getIsDefault()) {
            throw new BizRuntimeException("unable to modify default costTemplateCol");
        }
        this.updateById(costTemplateCol);
    }

    @Override
    public void add(CostTemplateCol costTemplateCol) {
        this.save(costTemplateCol);
    }

    @Override
    public void setCostTemplateCol(List<CostTemplate> costTemplateList) {
        List<Integer> costTemplateIds = costTemplateList.stream().map(CostTemplate::getId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(costTemplateIds)) {
            List<CostTemplateCol> costTemplateColList = this.list(new LambdaQueryWrapper<CostTemplateCol>()
                    .in(CostTemplateCol::getCostTemplateId, costTemplateIds));
            costTemplateBaseColService.setCostTemplateBaseCol(costTemplateColList);

            Map<Integer, List<CostTemplateCol>> map = costTemplateColList.stream().collect(Collectors.groupingBy(CostTemplateCol::getCostTemplateId));
            costTemplateList.forEach(costTemplate -> {
                costTemplate.setCostTemplateColList(map.get(costTemplate.getId()));
            });
        }
    }

    @Override
    public void setCostTemplateCol(CostTemplate costTemplate) {
        List<CostTemplateCol> costTemplateColList = this.list(new LambdaQueryWrapper<CostTemplateCol>()
                .eq(CostTemplateCol::getCostTemplateId, costTemplate.getId()));
        costTemplateBaseColService.setCostTemplateBaseCol(costTemplateColList);

        costTemplate.setCostTemplateColList(costTemplateColList);
    }
}
