package com.blt.other.module.cost.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class CostDetailDomain {
    private Integer id; // 费用单表 id
    private String detailNo; // 详情编号
    private String costNo; // 费用单编号
    private String companyNo; // 主体编号
    private String companyName; // 主体名称
    private String typeNo; // 类型编号
    private String typeName; // 类型标题

    @ApiModelProperty("会计一级科目")
    private String accountingSubjectNo;

    @ApiModelProperty("会计一级科目")
    private String accountingSubjectName;

    private Integer createUserid; // 创建人 id
    private String createUsercode; // 创建人编号
    private String createUsername; // 创建人名称
    private String costRemark; // 费用单备注

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime; // 创建时间
    private String sonCostNo; // 关联子单
    private String supCostNo; // 关联父单
    private Integer costStatus; // 费用单状态 0 未提交 1待审核 2待出纳付款 3已支付
    private String filePath; // 文件地址
    private String morFilePath; // 补充材料地址
    private BigDecimal amount; // 费用总金额
    private String bankName; // 收款银行（平台）
    private String bankCard; // 收款账户
    private String bankCardUser; // 收款用户名
    private String bankCompany; // 收款/付款单位
    private String morRemark; // 补充信息
    private Integer costForm; // 1 付款费用 2 收款费用 3 借支/借还
    private String costReason; // 付款理由
    private Integer isLend; // 1 借支 2 借还
    private BigDecimal hadPay; // 借支单已还金额
    private Integer lendStatus; // 借支单状态 1 未还 2 部分还款  3 结清
    private BigDecimal compensate; // 借支单补偿金额
    private BigDecimal counteract; // 冲销金额
    private BigDecimal lendBalance; // 借还单余额
    private String rejectReason; // 驳回原因
    private String dic; // 币种
    private BigDecimal payCounteract; // 借还单冲销金额 ( 支付币种 )
    private BigDecimal payLendBalance; // 借还单余额 （ 支付币种 ）
    private BigDecimal payPlanAmount; // 计划金额 （ 支付币种 ）
    private String payDic; // 支付币种
    private BigDecimal payCur; // 汇率
    private Integer isTax; // 0 不抵扣个税  1 抵扣个税
    private Integer companyValue; // 公司主体value

}

