package com.blt.other.other_cost.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.beans.factory.annotation.Value;

import java.math.BigDecimal;
import java.util.Date;

public class CostDto {
    private Integer id; // 费用单表 id
    private String costNo; // 费用单编号
    private String costPlanNo; // 费用计划编号
    private String companyNo; // 主体编号
    private String companyName; // 主体名称
    private String typeNo; // 大类编号
    private String typeName; // 大类标题
    private String kindNo; // 小类编号
    private String kindName; // 小类标题
    private Integer createUserid; // 创建人 id
    private String createUsercode; // 创建人编号
    private String createUsername; // 创建人名称
    private String costRemark; // 费用单备注
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date createTime; // 创建时间
    private String sonCostNo; // 关联子单
    private String supCostNo; // 关联父单
    private Integer costStatus; // 费用单状态 0 未提交 1待审核 2待出纳付款 3已支付
    private String costStatusDto; // 费用单状态 0 未提交 1待审核 2待出纳付款 3已支付
    private String filePath; // 文件地址
    private String fileName; // 文件名
    private String morFilePath; // 补充材料地址
    private String morFileName; // 补充材料文件名
    private BigDecimal amount; // 费用总金额
    private String amountDto;
    private Integer subLogisticsSupplierId; // 二级物流供应商ID
    private Integer logisticsSupplierId; // 一级物流供应商ID
    private String bankName; // 收款银行（平台）
    private String bankCard; // 收款账户
    private String bankCardUser; // 收款用户名
    private String bankCompany; // 收款/付款单位
    private String morRemark; // 补充信息
    private Integer isLend; // 0 普通费用  1 借支  2 借还
    private String isLendDto;// 0 普通费用  1 借支  2 借还
    private Integer costForm; // 费用类型
    private String costFormDto; // 费用类型
    private String costReason; // 付款理由
    private BigDecimal hadPay; // 借支单已还金额
    private Integer lendStatus; // 借支单状态 1 未还 2 部分还款  3 结清
    private String lendStatusDto;
    private BigDecimal compensate; // 借支单补偿金额
    private BigDecimal counteract; // 冲销金额
    private BigDecimal lendBalance; // 借还单余额
    private String rejectReason; // 驳回原因
    private String dic; // 币种
    private String dicDto; // 币种
    private BigDecimal payCounteract; // 借还单冲销金额 ( 支付币种 )
    private BigDecimal payLendBalance; // 借还单余额 （ 支付币种 ）
    private BigDecimal payPlanAmount; // 计划金额 （ 支付币种 ）
    private String payPlanAmountDto;
    private String payDic; // 支付币种
    private String payDicDto; // 支付币种
    private BigDecimal payCur; // 汇率
    private Integer isTax; // 0 不抵扣个税  1 抵扣个税
    private String isTaxStr; // 0 不抵扣个税  1 抵扣个税
    private String detailKey; // 出纳系统 detailKey
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date payTime; // 付款时间
    private Integer hasInvoice;
    private Integer rejectType;
    private Integer rejectTime;
    private String cashierFilePath;
    private String cashierDownloadPath;

    //费用来源 1-默认 2-WMS 3-调拨系统
    private String sourceFrom;
    //项目
    private String projectType;
    //客户编号
    private String customerNum;

    public String getDic() {
        return dic;
    }

    public void setDic(String dic) {
        this.dic = dic;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankCard() {
        return bankCard;
    }

    public void setBankCard(String bankCard) {
        this.bankCard = bankCard;
    }

    public String getBankCardUser() {
        return bankCardUser;
    }

    public void setBankCardUser(String bankCardUser) {
        this.bankCardUser = bankCardUser;
    }

    public Integer getCreateUserid() {
        return createUserid;
    }

    public void setCreateUserid(Integer createUserid) {
        this.createUserid = createUserid;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getMorFileName() {
        return morFileName;
    }

    public void setMorFileName(String morFileName) {
        this.morFileName = morFileName;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCostNo() {
        return costNo;
    }

    public void setCostNo(String costNo) {
        this.costNo = costNo;
    }

    public String getCompanyNo() {
        return companyNo;
    }

    public void setCompanyNo(String companyNo) {
        this.companyNo = companyNo;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getTypeNo() {
        return typeNo;
    }

    public void setTypeNo(String typeNo) {
        this.typeNo = typeNo;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getKindNo() {
        return kindNo;
    }

    public void setKindNo(String kindNo) {
        this.kindNo = kindNo;
    }

    public String getKindName() {
        return kindName;
    }

    public void setKindName(String kindName) {
        this.kindName = kindName;
    }

    public String getCreateUsercode() {
        return createUsercode;
    }

    public void setCreateUsercode(String createUsercode) {
        this.createUsercode = createUsercode;
    }

    public String getCreateUsername() {
        return createUsername;
    }

    public void setCreateUsername(String createUsername) {
        this.createUsername = createUsername;
    }

    public String getCostRemark() {
        return costRemark;
    }

    public void setCostRemark(String costRemark) {
        this.costRemark = costRemark;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getSonCostNo() {
        return sonCostNo;
    }

    public void setSonCostNo(String sonCostNo) {
        this.sonCostNo = sonCostNo;
    }

    public String getSupCostNo() {
        return supCostNo;
    }

    public void setSupCostNo(String supCostNo) {
        this.supCostNo = supCostNo;
    }

    public Integer getCostStatus() {
        return costStatus;
    }

    public void setCostStatus(Integer costStatus) {
        this.costStatus = costStatus;
    }

    public String getCostStatusDto() {
        return costStatusDto;
    }

    public void setCostStatusDto(String costStatusDto) {
        this.costStatusDto = costStatusDto;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getMorFilePath() {
        return morFilePath;
    }

    public void setMorFilePath(String morFilePath) {
        this.morFilePath = morFilePath;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getMorRemark() {
        return morRemark;
    }

    public void setMorRemark(String morRemark) {
        this.morRemark = morRemark;
    }

    public Integer getIsLend() {
        return isLend;
    }

    public void setIsLend(Integer isLend) {
        this.isLend = isLend;
    }

    public String getIsLendDto() {
        return isLendDto;
    }

    public void setIsLendDto(String isLendDto) {
        this.isLendDto = isLendDto;
    }

    public Integer getCostForm() {
        return costForm;
    }

    public void setCostForm(Integer costForm) {
        this.costForm = costForm;
    }

    public String getCostFormDto() {
        return costFormDto;
    }

    public void setCostFormDto(String costFormDto) {
        this.costFormDto = costFormDto;
    }

    public String getCostReason() {
        return costReason;
    }

    public void setCostReason(String costReason) {
        this.costReason = costReason;
    }

    public BigDecimal getHadPay() {
        return hadPay;
    }

    public void setHadPay(BigDecimal hadPay) {
        this.hadPay = hadPay;
    }

    public Integer getLendStatus() {
        return lendStatus;
    }

    public void setLendStatus(Integer lendStatus) {
        this.lendStatus = lendStatus;
    }

    public BigDecimal getCompensate() {
        return compensate;
    }

    public void setCompensate(BigDecimal compensate) {
        this.compensate = compensate;
    }

    public BigDecimal getCounteract() {
        return counteract;
    }

    public void setCounteract(BigDecimal counteract) {
        this.counteract = counteract;
    }

    public BigDecimal getLendBalance() {
        return lendBalance;
    }

    public void setLendBalance(BigDecimal lendBalance) {
        this.lendBalance = lendBalance;
    }

    public String getLendStatusDto() {
        return lendStatusDto;
    }

    public void setLendStatusDto(String lendStatusDto) {
        this.lendStatusDto = lendStatusDto;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public Integer getSubLogisticsSupplierId() {
        return subLogisticsSupplierId;
    }

    public void setSubLogisticsSupplierId(Integer subLogisticsSupplierId) {
        this.subLogisticsSupplierId = subLogisticsSupplierId;
    }

    public Integer getLogisticsSupplierId() {
        return logisticsSupplierId;
    }

    public void setLogisticsSupplierId(Integer logisticsSupplierId) {
        this.logisticsSupplierId = logisticsSupplierId;
    }

    public String getBankCompany() {
        return bankCompany;
    }

    public void setBankCompany(String bankCompany) {
        this.bankCompany = bankCompany;
    }

    public String getCostPlanNo() {
        return costPlanNo;
    }

    public void setCostPlanNo(String costPlanNo) {
        this.costPlanNo = costPlanNo;
    }

    public BigDecimal getPayCounteract() {
        return payCounteract;
    }

    public void setPayCounteract(BigDecimal payCounteract) {
        this.payCounteract = payCounteract;
    }

    public BigDecimal getPayLendBalance() {
        return payLendBalance;
    }

    public void setPayLendBalance(BigDecimal payLendBalance) {
        this.payLendBalance = payLendBalance;
    }

    public BigDecimal getPayPlanAmount() {
        return payPlanAmount;
    }

    public void setPayPlanAmount(BigDecimal payPlanAmount) {
        this.payPlanAmount = payPlanAmount;
    }

    public String getPayDic() {
        return payDic;
    }

    public void setPayDic(String payDic) {
        this.payDic = payDic;
    }

    public BigDecimal getPayCur() {
        return payCur;
    }

    public void setPayCur(BigDecimal payCur) {
        this.payCur = payCur;
    }

    public Integer getIsTax() {
        return isTax;
    }

    public void setIsTax(Integer isTax) {
        this.isTax = isTax;
    }

    public String getIsTaxStr() {
        return isTaxStr;
    }

    public void setIsTaxStr(String isTaxStr) {
        this.isTaxStr = isTaxStr;
    }


    public String getDicDto() {
        return dicDto;
    }

    public void setDicDto(String dicDto) {
        this.dicDto = dicDto;
    }

    public String getPayDicDto() {
        return payDicDto;
    }

    public void setPayDicDto(String payDicDto) {
        this.payDicDto = payDicDto;
    }

    public String getAmountDto() {
        return amountDto;
    }

    public void setAmountDto(String amountDto) {
        this.amountDto = amountDto;
    }

    public String getPayPlanAmountDto() {
        return payPlanAmountDto;
    }

    public void setPayPlanAmountDto(String payPlanAmountDto) {
        this.payPlanAmountDto = payPlanAmountDto;
    }


    public String getDetailKey() {
        return detailKey;
    }

    public void setDetailKey(String detailKey) {
        this.detailKey = detailKey;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public Integer getHasInvoice() {
        return hasInvoice;
    }

    public void setHasInvoice(Integer hasInvoice) {
        this.hasInvoice = hasInvoice;
    }

    public Integer getRejectType() {
        return rejectType;
    }

    public void setRejectType(Integer rejectType) {
        this.rejectType = rejectType;
    }

    public Integer getRejectTime() {
        return rejectTime;
    }

    public void setRejectTime(Integer rejectTime) {
        this.rejectTime = rejectTime;
    }

    public String getCashierFilePath() {
        return cashierFilePath;
    }

    public void setCashierFilePath(String cashierFilePath) {
        this.cashierFilePath = cashierFilePath;
    }

    public String getCashierDownloadPath() {
        return cashierDownloadPath;
    }

    public void setCashierDownloadPath(String cashierDownloadPath) {
        this.cashierDownloadPath = cashierDownloadPath;
    }

    @Override
    public String toString() {
        return "CostDto{" +
                "id=" + id +
                ", costNo='" + costNo + '\'' +
                ", costPlanNo='" + costPlanNo + '\'' +
                ", companyNo='" + companyNo + '\'' +
                ", companyName='" + companyName + '\'' +
                ", typeNo='" + typeNo + '\'' +
                ", typeName='" + typeName + '\'' +
                ", kindNo='" + kindNo + '\'' +
                ", kindName='" + kindName + '\'' +
                ", createUserid=" + createUserid +
                ", createUsercode='" + createUsercode + '\'' +
                ", createUsername='" + createUsername + '\'' +
                ", costRemark='" + costRemark + '\'' +
                ", createTime=" + createTime +
                ", sonCostNo='" + sonCostNo + '\'' +
                ", supCostNo='" + supCostNo + '\'' +
                ", costStatus=" + costStatus +
                ", costStatusDto='" + costStatusDto + '\'' +
                ", filePath='" + filePath + '\'' +
                ", fileName='" + fileName + '\'' +
                ", morFilePath='" + morFilePath + '\'' +
                ", morFileName='" + morFileName + '\'' +
                ", amount=" + amount +
                ", amountDto='" + amountDto + '\'' +
                ", subLogisticsSupplierId=" + subLogisticsSupplierId +
                ", logisticsSupplierId=" + logisticsSupplierId +
                ", bankName='" + bankName + '\'' +
                ", bankCard='" + bankCard + '\'' +
                ", bankCardUser='" + bankCardUser + '\'' +
                ", bankCompany='" + bankCompany + '\'' +
                ", morRemark='" + morRemark + '\'' +
                ", isLend=" + isLend +
                ", isLendDto='" + isLendDto + '\'' +
                ", costForm=" + costForm +
                ", costFormDto='" + costFormDto + '\'' +
                ", costReason='" + costReason + '\'' +
                ", hadPay=" + hadPay +
                ", lendStatus=" + lendStatus +
                ", lendStatusDto='" + lendStatusDto + '\'' +
                ", compensate=" + compensate +
                ", counteract=" + counteract +
                ", lendBalance=" + lendBalance +
                ", rejectReason='" + rejectReason + '\'' +
                ", dic='" + dic + '\'' +
                ", dicDto='" + dicDto + '\'' +
                ", payCounteract=" + payCounteract +
                ", payLendBalance=" + payLendBalance +
                ", payPlanAmount=" + payPlanAmount +
                ", payPlanAmountDto='" + payPlanAmountDto + '\'' +
                ", payDic='" + payDic + '\'' +
                ", payDicDto='" + payDicDto + '\'' +
                ", payCur=" + payCur +
                ", isTax=" + isTax +
                ", isTaxStr='" + isTaxStr + '\'' +
                ", detailKey='" + detailKey + '\'' +
                ", payTime=" + payTime +
                ", hasInvoice=" + hasInvoice +
                ", rejectType=" + rejectType +
                ", rejectTime=" + rejectTime +
                '}';
    }

    public String getCustomerNum() {
        return customerNum;
    }

    public void setCustomerNum(String customerNum) {
        this.customerNum = customerNum;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public String getSourceFrom() {
        return sourceFrom;
    }

    public void setSourceFrom(String sourceFrom) {
        this.sourceFrom = sourceFrom;
    }
}
