package com.blt.other.other_cost.controller;

import com.alibaba.fastjson.JSON;
import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_commons.utils.CurUtils;
import com.blt.other.other_commons.utils.IpUtil;
import com.blt.other.other_cost.service.*;
import com.blt.other.other_cost.vo.ApplyCallbackUrlVo;
import com.blt.other.other_cost.vo.ApplyCallbackVo;
import com.blt.other.other_cost.vo.ApplyMoneyDetail;
import com.blt.other.other_cost.vo.CashierCallbackUrlVo;
import com.blt.other.other_database.model.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("cost/check/lend")
public class CostCheckLendController {

    private static Logger logger = LoggerFactory.getLogger(CostCheckLendController.class);

    @Autowired
    private CostService costService;

    @Autowired
    private CostLogService costLogService;

    @Autowired
    private CostCompanyService costCompanyService;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private CostTofinanceService costTofinanceService;

    @Autowired
    private CostApplycallbackService costApplycallbackService;

    @Autowired
    private CostCashiercallbackService costCashiercallbackService;

    @Value("${url.my.lendCostApplyCallBackUrlPost}")
    private String lendCostApplyCallBackUrlPost;

    @Value("${url.my.lendCostCashierCallbackUrlPost}")
    private String lendCostCashierCallbackUrlPost;

    @Value("${url.api.postApplyApi}")
    private String postApplyApi;

    @Value("${url.api.getExchangeRateApi}")
    private String getExchangeRateApi;

    /**
     * 审核通过
     * @param request
     * @param response
     * @return
     */
    @PostMapping("/pass")
    public Map<String,Object> pass(HttpServletRequest request, HttpServletResponse response) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> map = null;
        String costNo = request.getParameter("costNo");
        String updateuserid = request.getParameter("updateuserid");

        // 获取借还单详情
        CostDomain costDomainByNo = costService.getCostDomainByNo(costNo);
        // 获取关联借支单详情
        CostDomain supCost = costService.getCostDomainByNo(costDomainByNo.getSupCostNo());
        int counteractCompare = costDomainByNo.getCounteract().compareTo(new BigDecimal(0));
        int lendBalanceCompare = costDomainByNo.getLendBalance().compareTo(new BigDecimal(0));

        if (counteractCompare == 0 && lendBalanceCompare == 0){
            // 冲销金额为0，借还单余额为0 即没有冲销，也没有返还余额，关联借支单的借支状态如果已还金额为0，则改为未还款，否则保持不变
            BigDecimal hadPay = supCost.getHadPay();
            int i = hadPay.compareTo(new BigDecimal(0));
            if (i == 0){
                // 已还金额为 0 ，状态改为未还款
                changeStatus(supCost.getCostNo(), supCost.getCostStatus(), 1, Integer.valueOf(updateuserid));
                map = changeStatus(costDomainByNo.getCostNo(),4,costDomainByNo.getLendStatus(), Integer.valueOf(updateuserid));
                map.put("success",true);
                map.put("msg","无效借还单，冲销：0  余额：0");
                return map;
            }
        }
        if (counteractCompare == 0 && lendBalanceCompare == 1){
            // 没有冲销，直接返还现金  创建一张返还现金的收款单，根据金额改变关联借支单状态和已还金额
            // 创建一张返还现金的收款单
            boolean toFinance = tofinanceMethod(costDomainByNo,2,"借还单收款",costDomainByNo.getAmount(),"借还单收款");
            if (toFinance) {
                if (null == supCost.getHadPay()){
                    supCost.setHadPay(new BigDecimal(0));
                }
                if ((supCost.getHadPay().add(costDomainByNo.getLendBalance())).compareTo(supCost.getAmount()) == 0) {
                    map = changeStatus(costDomainByNo.getCostNo(), 2, costDomainByNo.getLendStatus(), Integer.valueOf(updateuserid));
                }
                if ((supCost.getHadPay().add(costDomainByNo.getLendBalance())).compareTo(supCost.getAmount()) == -1) {
                    map = changeStatus(costDomainByNo.getCostNo(), 2, costDomainByNo.getLendStatus(), Integer.valueOf(updateuserid));
                }
            }
        }
        if (counteractCompare == 1 && lendBalanceCompare == 0){
            if (null == supCost.getHadPay()){
                supCost.setHadPay(new BigDecimal(0));
            }
            // 冲销，没有返还现金 创建一张无需付款的出纳单，根据冲销金额改变借支单状态和已还金额
            boolean toFinance = tofinanceMethod(costDomainByNo,3,"借还单冲销",costDomainByNo.getCounteract(),"借还单冲销");
            if (toFinance){
                supCost.setHadPay(supCost.getHadPay().add(costDomainByNo.getCounteract()));
                // 无需付款的出纳单，财务系统不会回调付款接口，将状态改为 已付款/收款
                changeStatus(costDomainByNo.getCostNo(), 4, costDomainByNo.getLendStatus(), Integer.valueOf(updateuserid));
                // 改变关联借支单的信息
                if (supCost.getHadPay().compareTo(supCost.getAmount()) == 0) {
                    supCost.setLendStatus(4);
                    if (supCost.getCompensate() != null && !(supCost.getCompensate().compareTo(new BigDecimal(0)) == 0)){
                        supCost.setLendStatus(3);
                    }
                }
                // 冲销后已还金额 小于 借支单金额  设置为部分还款
                if (supCost.getHadPay().compareTo(supCost.getAmount()) == -1) {
                    supCost.setLendStatus(2);
                }
                // 冲销后  已还金额 大于 借支单金额
                if (supCost.getHadPay().compareTo(supCost.getAmount()) == 1) {
                    // 差额 为 0  则结清
                    if (supCost.getCompensate().compareTo(new BigDecimal(0)) == 0) {
                        supCost.setLendStatus(4);
                    }
                    // 差额 >0  借支状态改为待补差额
                    if (supCost.getCompensate().compareTo(new BigDecimal(0)) == 1) {
                        supCost.setLendStatus(3);
                    }
                }
                costService.upadateCost(supCost);
            }
        }

        if (counteractCompare == 1 && lendBalanceCompare == 1){
            // 冲销，且有余额  原则上冲销金额+余额 = 借支单金额-已还金额
            String no = costDomainByNo.getCostNo();
            boolean lendBalanceToFinance = tofinanceMethod(costDomainByNo,2,"借还单余额",costDomainByNo.getLendBalance(),"借还单余额");
            costDomainByNo.setCostNo(no+"-1");
            boolean counteractToFinance = tofinanceMethod(costDomainByNo,3,"借还单冲销",costDomainByNo.getCounteract(),"借还单冲销");

            if (counteractToFinance && lendBalanceToFinance){
                map = changeStatus(no, 2, costDomainByNo.getLendStatus(), Integer.valueOf(updateuserid));

                if (null == supCost.getHadPay()){
                    supCost.setHadPay(new BigDecimal(0));
                }
                supCost.setHadPay(supCost.getHadPay().add(costDomainByNo.getCounteract()));
                supCost.setLendStatus(2);
                costService.upadateCost(supCost);
            }
            costLogService.save(costNo, Integer.valueOf(updateuserid),"财务审核费用单通过");
            costLogService.save(supCost.getCostNo(), Integer.valueOf(updateuserid),"借还单【" + costNo + "】冲销借支单【" + supCost.getCostNo() +
                    "】成功，冲销金额为" + costDomainByNo.getCounteract() + costDomainByNo.getDic() + "，归还金额为" + costDomainByNo.getLendBalance() + costDomainByNo.getDic());
            return map;
        }
        costLogService.save(costNo, Integer.valueOf(updateuserid),"财务审核费用单通过");
        costLogService.save(supCost.getCostNo(), Integer.valueOf(updateuserid),"借还单【" + costNo + "】冲销借支单【" + supCost.getCostNo() +
                "】成功，冲销金额为" + costDomainByNo.getCounteract() + costDomainByNo.getDic() + "，归还金额为" + costDomainByNo.getLendBalance() + costDomainByNo.getDic());
        return map;
    }

    @PostMapping(value = "invoice")
    public Map<String,Object> invoice (HttpServletRequest request, HttpServletResponse response) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> map = null;
        CostDomain costDomain = new CostDomain();
        String costNo = request.getParameter("costNo");
        String updateuserid = request.getParameter("updateuserid");
        int invoiceValue = Integer.parseInt(request.getParameter("hasInvoice"));
        costDomain.setHasInvoice(invoiceValue);
        costDomain.setCostNo(costNo);
        map = costService.upadateCost(costDomain);
        if(invoiceValue == 0) {
            costLogService.save(costNo, Integer.valueOf(updateuserid),"更改发票状态为：未给");
        }else if(invoiceValue == 1) {
            costLogService.save(costNo, Integer.valueOf(updateuserid),"更改发票状态为：已给");
        }
        map.put("success",true);
        map.put("msg","确认发票成功！");
        return map;
    }

    /**
     * 提交出纳
     * @param costDomain
     * @param payType
     * @param name
     * @return
     */
    private boolean tofinanceMethod(CostDomain costDomain, Integer payType,String name,BigDecimal payAmount,String title) {
        if (3 == payType){
            return true;
        }
        List<ApplyMoneyDetail> applyMoneyDetailList = new ArrayList<>();
        ApplyMoneyDetail applyMoneyDetail = new ApplyMoneyDetail();

        CostCompanyDomain companyByCompanyNo = costCompanyService.getCompanyByCompanyNo(costDomain.getCompanyNo());

        //  提交财务
        MultiValueMap<String, Object> requestEntity = new LinkedMultiValueMap<>();
        requestEntity.add("Title", costDomain.getCostNo());// 申请标题(Title)不可为空；
        requestEntity.add("CompanyMainName", costDomain.getCompanyName()); // 公司主体(CompanyMainName)不可为空；
        requestEntity.add("ApplyCallbackUrl", lendCostApplyCallBackUrlPost); // 审核回调地址(ApplyCallbackUrl)不可为空；
        requestEntity.add("CashierCallbackUrl", lendCostCashierCallbackUrlPost); // 出纳回调地址(CashierCallbackUrl)不可为空；
        requestEntity.add("UnitCode", costDomain.getPayDic()); // 币种编号(UnitCode)不可为空；
        requestEntity.add("UnitName", costDomain.getPayDic()); // 币种名称(UnitName)不可为空；
        requestEntity.add("TradeObjectID", companyByCompanyNo.getValue() + "");
        requestEntity.add("TradeObjectName", costDomain.getBankCompany() + ""); // 交易对象(TradeObjectID/TradeObjectName)不可为空；
        requestEntity.add("BankNameto", "" + costDomain.getBankName());
        requestEntity.add("BankCardto", "" + costDomain.getBankCard());
        requestEntity.add("BankCardUserto", "" + costDomain.getBankCardUser()); // 交易对象账户(BankNameto/BankCardto/BankCardUserto)资料不完整；
        requestEntity.add("SourceCode", "newCost");
        requestEntity.add("SourceTypeCode", "newCostType"); // newOtherPurchase申请来源(SourceCode/SourceTypeCode)不可为空；
        applyMoneyDetail.setMoney(payAmount);
        applyMoneyDetail.setMoneyRmb(payAmount);
        requestEntity.add("ApplyType", "" + payType); // 申请类型(ApplyType)不存在；申请类型:1#付款;2#收款;3#无需付款;
        applyMoneyDetail.setName(name);
        requestEntity.add("UserAcctID", "" + costDomain.getCreateUserid());
        requestEntity.add("UserAcctName", "" + costDomain.getCreateUsername()); // 申请人(UserAcctID/UserAcctName)不存在；
        // 账期 0 PayDay
        requestEntity.add("PayDay", 0);
        // 预计付款时间 ExpectPayTime
        requestEntity.add("ExpectPayTime", new Date());
        applyMoneyDetail.setRemark("");
        applyMoneyDetailList.add(applyMoneyDetail);
        requestEntity.add("MoneyDetail", applyMoneyDetailList); // 出纳申请金额明细(MoneyDetail)不可为空；
        // 设置 detailKey
        String detailKey = costDomain.getDetailKey();
        if (null == detailKey || !detailKey.contains("F")){
            detailKey = costDomain.getCostNo();
        }
        requestEntity.add("DetailKey", detailKey); // 回调必要的key参数（DetailKey）不能为空；
        // 吴通 增加费用大类
        requestEntity.add("TypeName",costDomain.getTypeName());
        Map<String, Object> map = requestEntity.toSingleValueMap();
        String s = JSON.toJSONString(map);
        logger.warn(name+"提交财务审核信息："+s);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        HttpEntity<String> entity = new HttpEntity<String>(s, headers);
        ResponseEntity<String> response = restTemplate.postForEntity(postApplyApi, entity, String.class);

        String strBody = null;
        if (null != response && response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
            strBody = strBody.toLowerCase();
            strBody = strBody.replace("\\", "");
            if (strBody.contains("申请单已存在")) {
                logger.warn("申请单已存在：" + strBody);
                return true;
            } else if (strBody.contains("创建")) {
                //  将 strBody 保存到数据库 costTofinance 表
                ObjectMapper mapper = new ObjectMapper();
                try {
                    //  将 strBody 转换为标准 JSONString 格式
                    int i = strBody.lastIndexOf("data\":");
                    String substr1 = strBody.substring(0, i + 6);
                    String substr2 = strBody.substring(i + 7, strBody.length() - 2);
                    strBody = substr1 + substr2 + "}";

                    ApplyCallbackVo applyCallbackVo = mapper.readValue(strBody, ApplyCallbackVo.class);
                    logger.warn(strBody);

                    // 将反馈信息保存到数据库
                    CostTofinanceDomain costTofinanceDomain = null;
                    if (null != applyCallbackVo && applyCallbackVo.isSuccess()) {
                        costTofinanceDomain = new CostTofinanceDomain();
                        BeanUtils.copyProperties(applyCallbackVo.getData(), costTofinanceDomain);
                        costTofinanceDomain.setCostNo(costDomain.getCostNo().toUpperCase());
                        costTofinanceDomain.setCode(costTofinanceDomain.getCode().toUpperCase());
                        // 执行 insert 流程
                        Integer costTofinanceInteger = costTofinanceService.saveCostTofinanceMsg(costTofinanceDomain);
                        return true;
                    }
                } catch (IOException e) {
                    logger.error("财务审核申请单信息保存到数据库失败" + strBody);
                    return false;
                }

            }
        }
        return false;
    }

    /**
     * 财务审核回调接口
     * @param request
     * @return
     */
    @PostMapping(value = "ApplyCallbackUrl",consumes ="application/json")
    public String applyCallbackUrl(HttpServletRequest request){
        String line = null;
        String result = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(request.getInputStream()));
            line = br.readLine();
        } catch (IOException e) {
            logger.error(IpUtil.getIpAddr(request)+" CostApplyCallbackUrl "+" 借还单审核反馈信息获取失败");
            result = "{result:false,msg:\"发生错误\"}";
            return result;
        }
        line = line.replace("\\","");
        // 格式化为标准 json 格式
        int data = line.lastIndexOf("Data");
        int id = line.lastIndexOf("id");
        String substring1 = line.substring(0,data + 6);
        String substring2 = line.substring(data + 7, id - 4);
        String substring3 = line.substring(id - 3, line.length());
        line = substring1+substring2+substring3;
        line = line.toLowerCase();

        //保存为 bean,并且将反馈信息保存到数据库
        ObjectMapper mapper = new ObjectMapper();
        ApplyCallbackUrlVo applyCallbackUrlVo = null;
        try {
            applyCallbackUrlVo = mapper.readValue(line, ApplyCallbackUrlVo.class);
            if (null == applyCallbackUrlVo){
                logger.error("保存借还单财务审核信息发生错误："+line);
                result = "{result:false,msg:\"发生错误\"}";
                return result;
            }
            // 执行保存反馈信息流程
            CostApplycallbackDomain applycallbackDomain = new CostApplycallbackDomain();
            BeanUtils.copyProperties(applyCallbackUrlVo.getData().getData(),applycallbackDomain);
            String costNo = applyCallbackUrlVo.getId().toUpperCase();
            if (null != costNo && costNo.contains("-")){
                costNo = costNo.split("-")[0];
            }
            applycallbackDomain.setCostNo(costNo);
            applycallbackDomain.setMessage(applyCallbackUrlVo.getData().getMessage().toUpperCase());
            applycallbackDomain.setApplyno(applycallbackDomain.getApplyno().toUpperCase());
            Integer integer = costApplycallbackService.saveApplycallbackResponse(applycallbackDomain);
            logger.warn("保存财务审核信息成功："+integer+"    "+line);
        } catch (IOException e) {
            logger.error("保存财务审核信息发生错误："+line);
            result = "{result:false,msg:\"发生错误\"}";
            return result;
        }
        result = "{result:true,msg:\"\"}";
        return result;
    }

    /**
     * 财务付款回调接口
     * @param request
     * @return
     */
    @PostMapping(value = "CashierCallbackUrl",consumes ="application/json")
    public String cashierCallbackUrl(HttpServletRequest request) {
        String result = null;
        // 将状态改为审核通过、已付款
        logger.warn("费用系统借还单出纳回调"+IpUtil.getIpAddr(request) + " CashierCallbackUrl ");

        String line = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(request.getInputStream()));
            line = br.readLine();
            line = line.replace("\\","");

            // 格式化为标准 json 格式
            int data = line.lastIndexOf("Data");
            int id = line.lastIndexOf("id");
            String substring1 = line.substring(0,data + 6);
            String substring2 = line.substring(data + 7, id - 4);
            String substring3 = line.substring(id - 3, line.length());
            line = substring1+substring2+substring3;
            line = line.toLowerCase();
            line = line.replace("_","");
            logger.warn("费用系统借还支付反馈信息："+line);

            ObjectMapper mapper = new ObjectMapper();
            CashierCallbackUrlVo cashierCallbackUrlVo = null;
            CostCashiercallbackDomain costCashiercallbackDomain = new CostCashiercallbackDomain();
            try {
                cashierCallbackUrlVo = mapper.readValue(line,CashierCallbackUrlVo.class);
                if (cashierCallbackUrlVo == null){
                    logger.error("费用系统保存借还出纳付款信息发生错误："+line);
                    result = "{result:false,msg:\"发生错误\"}";
                    return result;
                }
                BeanUtils.copyProperties(cashierCallbackUrlVo.getData(),costCashiercallbackDomain);
                BeanUtils.copyProperties(cashierCallbackUrlVo.getData().getData(),costCashiercallbackDomain);
                BeanUtils.copyProperties(cashierCallbackUrlVo.getData().getData().getPaydetail(),costCashiercallbackDomain);
                String costNo = cashierCallbackUrlVo.getId().toUpperCase();
                if (null != costNo && costNo.contains("-")){
                    String[] split = costNo.split("-");
                    costNo=split[0];
                }
                costCashiercallbackDomain.setCostNo(costNo);
                costCashiercallbackDomain.setMessage(costCashiercallbackDomain.getMessage().toUpperCase());
                costCashiercallbackDomain.setPayno(costCashiercallbackDomain.getPayno().toUpperCase());

                // 被出纳驳回
                if (costCashiercallbackDomain.getMessage().contains("被驳回")){
                    boolean b = finansysReject(costCashiercallbackDomain);
                    if (b){
                        logger.info("借还出纳驳回，费用单状态更改成功"+costCashiercallbackDomain);
                        costLogService.save(costNo, costCashiercallbackDomain.getPayuserid(),"被出纳驳回："+costCashiercallbackDomain.getPaynote());
                    }else {
                        logger.info("借还出纳驳回，费用单状态更改失败"+costCashiercallbackDomain);
                    }
                    result = "{result:true,msg:\"出纳驳回\"}";
                    return result;
                }

                //  保存出纳付款记录
                Integer integer = costCashiercallbackService.saveCostCashiercallbackResponse(costCashiercallbackDomain);
                logger.warn("保存出纳付款信息成功："+integer+"   "+costCashiercallbackDomain);
            } catch (IOException e) {
                logger.error("保存出纳付款信息发生错误："+line);
                result = "{result:false,msg:\"发生错误\"}";
                return result;
            }
            //  付款成功，更改借还单信息，否则返回失败
            CostDomain costDomainByNo = costService.getCostDomainByNo(costCashiercallbackDomain.getCostNo());
            String sonNo = costDomainByNo.getCostNo().toUpperCase();
            Map<String, Object> map = changeStatus(costCashiercallbackDomain.getCostNo(), 4,costDomainByNo.getLendStatus(), costCashiercallbackDomain.getPayuserid());
            if (null != map ) {
                if (sonNo.contains("S")){
                    CostDomain supCostDomain = costService.getCostDomainByNo(costDomainByNo.getSupCostNo());
                    if (null == supCostDomain.getHadPay()) supCostDomain.setHadPay(new BigDecimal(0));
                    if (null == supCostDomain.getCompensate()) supCostDomain.setCompensate(new BigDecimal(0));
//                    supCostDomain.setCompensate(supCostDomain.getCompensate().add(costCashiercallbackDomain.getPayamount()));
                    supCostDomain.setCompensate(supCostDomain.getCompensate().subtract(costCashiercallbackDomain.getPayamount()));
//                    supCostDomain.setHadPay(supCostDomain.getHadPay().add(costCashiercallbackDomain.getPayamount()));
                    // 借还单在出纳完成收付款后，不用直接获取返回的金额（使用费用系统中记录的提交金额，出纳系统结算的实时汇率和费用系统不一定一致）
                    supCostDomain.setHadPay(supCostDomain.getHadPay().add(costDomainByNo.getAmount()));
//                    int i = supCostDomain.getAmount().compareTo(supCostDomain.getHadPay().subtract(supCostDomain.getCompensate()));
                    BigDecimal zero = new BigDecimal(0);
                    if (supCostDomain.getCompensate().compareTo(zero) == 0){
                        supCostDomain.setLendStatus(4);
                        // 已补差额，但是仍有金额未到账
                        BigDecimal allPayAmount = supCostDomain.getAmount().add(costCashiercallbackDomain.getPayamount());
                        int i = allPayAmount.compareTo(supCostDomain.getHadPay());
                        if (1 == i){
                            supCostDomain.setLendStatus(2);
                        }
                    }

//                    if (i == -1){
//                        supCostDomain.setLendStatus(2);
//                    }
                    if (supCostDomain.getCompensate().compareTo(zero) == 1){
                        supCostDomain.setLendStatus(3);
                    }
                    costService.upadateCost(supCostDomain);
                }
                if (!sonNo.contains("S") && null != costDomainByNo.getSupCostNo()){
                    CostDomain supCostDomain = costService.getCostDomainByNo(costDomainByNo.getSupCostNo());
                    if (null == supCostDomain.getHadPay()){
                        supCostDomain.setHadPay(new BigDecimal(0));
                    }
//                    supCostDomain.setHadPay(supCostDomain.getHadPay().add(costCashiercallbackDomain.getCashierpaymoney()));
                    // 借还单在出纳完成收付款后，不用直接获取返回的金额（使用费用系统中记录的提交金额，出纳系统结算的实时汇率和费用系统不一定一致）
                    supCostDomain.setHadPay(supCostDomain.getHadPay().add(costDomainByNo.getAmount()));
                    if (supCostDomain.getHadPay().compareTo(supCostDomain.getAmount()) == 0){
                        supCostDomain.setLendStatus(4);
                    }
                    if (supCostDomain.getHadPay().compareTo(supCostDomain.getAmount()) == -1){
                        supCostDomain.setLendStatus(2);
                    }
                    if (supCostDomain.getHadPay().compareTo(supCostDomain.getAmount()) == 1){
                        supCostDomain.setLendStatus(3);
                        supCostDomain.setCompensate(supCostDomain.getHadPay().subtract(supCostDomain.getAmount()));
                    }
                    costService.upadateCost(supCostDomain);
                }
                result = "{result:true,msg:\"保存成功\"}";
                costLogService.save(costCashiercallbackDomain.getCostNo(), costCashiercallbackDomain.getPayuserid(),"出纳收/付款成功："+costCashiercallbackDomain.getPaynote());
            }else {
                result = "{result:false,msg:\"发生错误\"}";
            }
        } catch (IOException e) {
            logger.error(IpUtil.getIpAddr(request)+" CashierCallbackUrl "+" 出纳付款反馈信息获取失败");
            result = "{result:false,msg:\"发生错误\"}";
            return result;
        }
        return result;
    }


    /**
     * 出纳驳回
     * @param domain
     * @return
     */
    private boolean finansysReject(CostCashiercallbackDomain domain) {
        // 保存驳回信息
        Integer integer = costCashiercallbackService.saveCostCashiercallbackResponse(domain);
        if (null != integer && integer >= 1) {
            // 费用单状态改为审核驳回，添加驳回理由
            // 修复驳回后提交出现费用单已存在的问题
            // 将后缀添加到  detail_key 字段
            CostDomain oldCost = costService.getByNo(domain.getCostNo());
            String oldDetailKey = oldCost.getDetailKey();
            CostDomain costDomain = new CostDomain();
            costDomain.setId(oldCost.getId());
            if (null != oldDetailKey && oldDetailKey.contains("-")) {
                String[] split = oldDetailKey.split("-");
                if (null != split && split.length > 1) {
                    costDomain.setDetailKey(split[0] + "-" + (Integer.parseInt(split[1]) + 1));
                }
            } else {
                costDomain.setDetailKey(oldCost.getCostNo() + "-" + 1);
            }
            costDomain.setRejectReason(domain.getPaynote());
            costDomain.setCostStatus(3);
            costDomain.setRejectType(2);
            Integer result = costService.updateById(costDomain);
        }
        return true;
    }

    /**
     * 改变费用单状态
     * @param costNo
     * @param costStatus
     * @return
     */
    private Map<String,Object> changeStatus(String costNo,Integer costStatus,Integer lendStatus, Integer updateUserId){
        Date now = new Date();
        CostDomain costDomain = costService.getCostDomainByNo(costNo);
        costDomain.setCostStatus(costStatus);
        costDomain.setCostNo(costNo);
        costDomain.setLendStatus(lendStatus);
        costDomain.setPayUserId(updateUserId);
        costDomain.setPayTime(now);
        BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY", getExchangeRateApi);
        costDomain.setToRmbRate(toRmbRate);
        costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        costDomain.setAuditTime(now);
        Map<String, Object> map = costService.upadateCost(costDomain);

        return map;

    }

    private CostDomain createSonCost(CostDomain supCost){
        CostDomain sonCost = new CostDomain();
        BeanUtils.copyProperties(supCost,sonCost);
        sonCost.setHadPay(new BigDecimal(0));
        sonCost.setAmount(supCost.getHadPay().subtract(supCost.getAmount()));
        sonCost.setSupCostNo(supCost.getCostNo());
        sonCost.setCostStatus(1);
        sonCost.setCostReason("借支单差额:"+supCost.getCostNo());
        sonCost.setCostForm(1);
        sonCost.setTypeName("借支单差额");
        sonCost.setKindName("借支单号："+supCost.getCostNo());
        sonCost.setIsLend(0);
        sonCost.setLendStatus(null);
        return sonCost;
    }
}
