package com.blt.other.other_cost.service;

import com.blt.other.other_cost.dto.CostDto;
import com.blt.other.other_cost.vo.CostCheckSearchKeysVo;
import com.blt.other.other_database.model.CostDomain;

import java.util.List;
import java.util.Map;

public interface CostCheckSearchService {

    Map<String,Object> getAll(Integer pageNum,Integer pageSize);

    /**
     * 通过关键字模糊查询
     * @param key
     * @return
     */
    Map<String,Object> seachByKey(String key,int pageNum,int pageSize);

    List<CostDto> domainListToDto(List<CostDomain> domains);

    /**
     * 多条件筛选
     * @param searchKeysVo
     * @return
     */
    Map<String,Object> searchByKeys(CostCheckSearchKeysVo searchKeysVo);

    List<CostDomain> getLinkCost();
}
