package com.blt.other.other_cost.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_commons.utils.MyMapperUtil;
import com.blt.other.other_commons.utils.PathUtil;
import com.blt.other.other_cost.dto.CostDto;
import com.blt.other.other_cost.service.CostExportService;
import com.blt.other.other_cost.service.CostLogService;
import com.blt.other.other_cost.service.CostService;
import com.blt.other.other_cost.service.UserCostFinansysService;
import com.blt.other.other_cost.utils.CostFileUtil;
import com.blt.other.other_cost.utils.CostUtils;
import com.blt.other.other_cost.vo.CostExportVo;
import com.blt.other.other_database.model.CostDomain;
import com.blt.other.other_database.model.CostExpDomain;
import com.blt.other.other_database.model.UserCostFinansysDomain;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.sun.scenario.effect.impl.sw.sse.SSEBlend_SRC_OUTPeer;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.*;

@RestController
@RequestMapping("cost/list/")
public class CostListController {
    @Autowired
    private CostService costService;

    @Autowired
    private UserCostFinansysService userCostFinansysService;

    @Autowired
    private CostExportService costExportService;

    @Autowired
    private CostLogService costLogService;

    /**
     * 获取所有费用单
     * @param response
     * @param request
     * @return
     */
    @GetMapping("getAllCost")
    public Map<String,Object> getAllCost(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response,request);

        String pageNum = request.getParameter("pageNum");
        String pageSize = request.getParameter("pageSize");
        Integer userId = (request.getParameter("userId") == null ? null : Integer.valueOf(request.getParameter("userId")));
        Integer authType = (request.getParameter("authType") == null ? 0 : Integer.valueOf(request.getParameter("authType")));
        if(authType != 0) {
            userId = null;
        }
        Map<String, Object> result = costService.getAllCost(Integer.parseInt(pageNum),Integer.parseInt(pageSize), userId);
        result.put("success",true);
        return result;
    }

    /**
     * 获取费用单详情
     * @param response
     * @param request
     * @return
     */
    @PostMapping("getCostDetail")
    public Map<String,Object> getCostDetail(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response,request);

        String costNo = request.getParameter("costNo");

        Map<String, Object> costByCostNo = costService.getCostByCostNo(costNo);
        costByCostNo.put("msg","success");
        return costByCostNo;
    }

    /**
     * 信息修改，带附件
     * @param response
     * @param request
     * @param file
     * @return
     */
    @PostMapping("reset/resetFile")
    public Map<String,Object> resetFile(HttpServletResponse response, HttpServletRequest request,@RequestParam("fileSelect") MultipartFile file) {
        AxiosUtil.setCors(response,request);

        String costNo = request.getParameter("costNo");
        CostDomain costDomain = CostUtils.createCostDomain(request,costNo);
        boolean saveRecord = saveRecord(costDomain);
        if (saveRecord){
            Integer integer = doSaveFinansyRecord(costDomain);
        }
        // 文件上传的路径
        String filePath = PathUtil.getBasePath()+PathUtil.getPath("cost/"+costDomain.getCostNo()+"/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(file, filePath);
        costDomain.setFilePath(path);
        Map<String, Object> map = costService.upadateCost(costDomain);
        costLogService.save(costNo, costService.getCostDomainByNo(costNo).getCreateUserid(),"修改费用单");
        map.put("success",true);
        return map;
    }

    /**
     * 信息修改，不带附件
     * @param response
     * @param request
     * @return
     */
    @PostMapping("reset/resetNoFile")
    public Map<String,Object> resetNoFile(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response,request);

        CostDomain costDomain = CostUtils.createCostDomain(request,request.getParameter("costNo"));
        boolean saveRecord = saveRecord(costDomain);
        if (saveRecord){
            Integer integer = doSaveFinansyRecord(costDomain);
        }

        Map<String, Object> map = costService.upadateCost(costDomain);
        costLogService.save(costDomain.getCostNo(), costService.getCostDomainByNo(costDomain.getCostNo()).getCreateUserid(),"修改费用单");
        map.put("success",true);
        return map;
    }

    @PostMapping("submitAudit")
    public Map<String,Object> submitAudit(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response,request);

        String costNo = request.getParameter("costNo");
        CostDomain costDomainByNo = costService.getCostDomainByNo(costNo);
        costDomainByNo.setCostStatus(1);

        Map<String, Object> map = costService.upadateCost(costDomainByNo);
        costLogService.save(costNo, costDomainByNo.getCreateUserid(), "提交费用单");
        return map;
    }

    /**
     * 获取借支单列表
     * @param request
     * @param response
     * @return
     */
    @GetMapping("/getAllLendCost")
    public Map<String,Object> getAllLendCost(HttpServletRequest request,HttpServletResponse response){
        AxiosUtil.setCors(response,request);
        String createuserid = request.getParameter("createuserid");
        Map<String,Object> result = new HashMap<>();
//        List<CostDto> costByLend = costService.getCostByLend(1);
        List<CostDto> costDtos = costService.getLinkLendCost(Integer.valueOf(createuserid));
//        List<CostDto> costDtos = new ArrayList<>();
//        if (null != costByLend && costByLend.size() >=1){
//            for (CostDto costDto : costByLend){
//                if (costDto.getCostStatus() == 4 && (null != costDto.getLendStatus() && 3 > costDto.getLendStatus())){
//                    costDtos.add(costDto);
//                }
//            }
//        }
        result.put("success",true);
        result.put("lends",costDtos);
        result.put("msg","");
        return result;
    }

    @PostMapping("/getCostByCostPlanNo")
    public Map<String,Object> getCostByCostPlanNo(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);

        Map<String,Object> result = new HashMap<>();

        String costPlanNo = request.getParameter("costPlanNo");
        List<CostDto> costDtos = costService.getByCostPlanNo(costPlanNo);

        result.put("costs",costDtos);
        return result;
    }

    /**
     * 保存填写的财务信息
     * @return
     */
    private Integer doSaveFinansyRecord(CostDomain costDomain){
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostDomain(costDomain);
        Integer integer = userCostFinansysService.saveFinansysRecord(finansyRecordByCostDomain);
        return integer;
    }

    /**
     * 判断是否存在相同记录
     * @param costDomain
     * @return
     */
    private boolean saveRecord(CostDomain costDomain){
//        Integer costForm = costDomain.getCostForm();
//        if (2 == costForm || (3 == costForm && 2 == costDomain.getIsLend())){
//            return false;
//        }
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostDomain(costDomain);
        UserCostFinansysDomain byUserCostFinansysDetail = userCostFinansysService.getByUserCostFinansysDetail(finansyRecordByCostDomain);
        if (null != byUserCostFinansysDetail && null != byUserCostFinansysDetail.getId()){
            return false;
        }else {
            return true;
        }
    }

    @PostMapping("/deleted")
    public Map<String,Object> deleted(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String costNo = request.getParameter("costNo");
        Integer set = costService.setStatus(costNo,5);
        if (null != set && set >= 1) {
            result.put("success", true);
            costLogService.save(costNo, costService.getCostDomainByNo(costNo).getCreateUserid(), "作废费用单");
        }
        return result;
    }

    @PostMapping("/exportList")
    public String exportList(HttpServletResponse response, HttpServletRequest request) throws IOException {
        AxiosUtil.setCors(response,request);
        Enumeration<String> parameterNames = request.getParameterNames();
        if (null != parameterNames && parameterNames.hasMoreElements()) {
            String s = parameterNames.nextElement();
            CostExportVo costExportVo = (CostExportVo) MyMapperUtil.getObject(s, CostExportVo.class);
            String filePath = costExportService.exportFees(costExportVo.getParams().getExportNos());
            // 保存下载记录
            CostExpDomain exp = costExportService.saveRecord(costExportVo,filePath);
            return exp.getExpNo();
        }
        return null;
    }

    @GetMapping("download")
    public ResponseEntity<InputStreamResource> download(HttpServletRequest request, HttpServletResponse response) throws IOException {
//        AxiosUtil.setCors(response,request);
        String pathNo = request.getParameter("pathNo");
        CostExpDomain exp = costExportService.getByExpNo(pathNo);
        String filePath = exp.getExpPath();
        String fileName = PathUtil.getFileName(filePath);
        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"),"iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }
}
