package com.blt.other.module.cost.service.impl;

import com.bailuntec.common.BeanUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.common.util.PathUtil;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostDetailDao;
import com.blt.other.module.cost.dto.request.ResetReq;
import com.blt.other.module.cost.dto.response.ResetResp;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.service.CostDetailService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.utils.CostFileUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service
public class CostDetailServiceImpl extends ServiceImpl<CostDetailDao, CostDetailDomain> implements CostDetailService {

    @Resource
    private CostDetailDao costDetailDao;
    @Resource
    CostService costService;

    @Override
    public List<CostDetailDomain> getCostDetailListByCostNo(String costNo) {
        return costDetailDao.selectListByCostNo(costNo);
    }

    @Override
    public CostDetailDomain getCostDetailByDetailNo(String detailNo) {
        return costDetailDao.selectByDetailNo(detailNo);
    }

    @Override
    public void deleteFilePath(String detailNo) {
        costDetailDao.deletedFilePath(detailNo);
    }


    @Transactional
    @Override
    public Integer update(CostDetailDomain domain) {
        //更新费用单
        return costDetailDao.update(domain, new LambdaQueryWrapper<CostDetailDomain>()
                .eq(CostDetailDomain::getDetailNo, domain.getDetailNo()));
    }

    @Override
    public ResetResp reset(ResetReq req) {
        CostDetailDomain costDetailDomain = this.getCostDetailByDetailNo(req.getDetailNo());
        BeanUtils.copyProperties(req, costDetailDomain);

        if (req.getFileSelect2() != null) {
            // 文件上传的路径
            String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/" + costDetailDomain.getDetailNo() + "/");
            // 调用工具类执行保存，并返回 path
            String path = CostFileUtil.upload(req.getFileSelect2(), filePath);
            costDetailDomain.setFilePath(path);
        }

        baseMapper.updateById(costDetailDomain);
        costService.resetCost(costDetailDomain.getCostNo());

        ResetResp resetResp = new ResetResp();
        resetResp.setDetail(costDetailDomain);
        resetResp.setSuccess(true);
        return resetResp;
    }
}
