package com.blt.other.module.cost.service.impl.cost;

import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostListPrintDto;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.MoneyUtil;
import com.blt.other.module.auth.dao.CostReviewerMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.CostReviewer;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.auth.service.UserService;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostDetailDao;
import com.blt.other.module.cost.dao.CostTypeKindDao;
import com.blt.other.module.cost.dto.CostApiDto;
import com.blt.other.module.cost.dto.CostPageResult;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.cost.service.CostLogService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.service.ICostTemplateService;
import com.blt.other.module.database.model.CostCompanyDomain;
import com.blt.other.module.database.model.CostLogDomain;
import com.blt.other.module.database.model.CostTypeKindDomain;
import com.blt.other.module.database.model.UserDomain;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 11:35 上午
 */
@Slf4j
public abstract class AbstractCostService implements CostService {

    @Autowired
    CostDao costDao;
    @Autowired
    UserService userService;
    @Autowired
    ICostTemplateService costTemplateService;
    @Autowired
    CostCompanyDao costCompanyDao;
    @Autowired
    CostTypeKindDao costTypeKindDao;
    @Autowired
    CostDetailDao costDetailDao;
    @Autowired
    CostLogService costLogService;
    @Resource
    CostSubscribe costSubscribe;
    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    OaUserMapper oaUserMapper;

    @Override
    public Integer saveNewCost(CostDomain costDomain) {
        throw new BizRuntimeException("deprecated method");
    }

    @Override
    public CostPageResult getAllCost(Integer pageNum,
                                     Integer pageSize,
                                     Integer userId,
                                     String projectTypes) {
        PageHelper.startPage(pageNum, pageSize);
        List<String> projectTypeList = new ArrayList<>();
        if (!StringUtils.isEmpty(projectTypes)) {
            projectTypeList = Lists.newArrayList(projectTypes.split(",")).stream().filter(str -> !StringUtils.isEmpty(str)).collect(Collectors.toList());
        }
        List<CostDomain> costDomains = costDao.selectAll(userId, projectTypeList);

        CostPageResult result = new CostPageResult();
        result.setCosts(costDomains.stream().map(CostDomain::castToDto).collect(Collectors.toList()));
        result.setPageInfo(new PageInfo<>(costDomains));
        return result;
    }

    @Override
    public CostDomain getCostByCostNo(String costNo) {
        CostDomain costDomain = costDao.selectByCostNo(costNo);
        costDomain.setCostTemplate(costTemplateService.queryDetail(costDomain.getCostTemplateId()));
        return costDomain;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public CostApiDto.UpdateCostResp updateCost(CostDomain costDomain) {
        CostApiDto.UpdateCostResp resp = new CostApiDto.UpdateCostResp();

        setCostDomain(costDomain);
        Integer update = costDao.update(costDomain);


        resp.setMsg("success");
        resp.setResult(costDao.selectByCostNo(costDomain.getCostNo()));
        resp.setUpdate(update);
        return resp;

    }

    private void setCostDomain(CostDomain costDomain) {
        if (null != costDomain.getCompanyNo()) {
            costDomain.setCompanyName(costCompanyDao.selectByNo(costDomain.getCompanyNo()).getCompanyName());
        }
        if (null != costDomain.getKindNo() && !"".equals(costDomain.getKindNo())) {
            CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(costDomain.getKindNo());
            if (null != costTypeKindDomain) {
                costDomain.setKindName(costTypeKindDomain.getKindName());
                costDomain.setTypeName(costTypeKindDomain.getTypeName());
                costDomain.setTypeNo(costTypeKindDomain.getTypeNo());
            }
        }
    }


    @Override
    public List<CostDto> getByCostPlanNo(String costPlanNo) {
        return costDao.selectByCostPlanNo(costPlanNo)
                .stream()
                .map(CostDomain::castToDto)
                .collect(Collectors.toList());
    }

    @Override
    public void resetCost(String costNo) {
        List<CostDetailDomain> costDetailDomains = costDetailDao.selectListByCostNo(costNo);
        BigDecimal amount = new BigDecimal(0);
        if (null != costDetailDomains && costDetailDomains.size() >= 1) {
            for (CostDetailDomain domain : costDetailDomains) {
                amount = amount.add(domain.getAmount());
            }
            CostDomain costDomain = new CostDomain();
            costDomain.setCostNo(costNo);
            costDomain.setAmount(amount);
            costDomain.setKindName(costDetailDomains.get(0).getKindName() + " 等 " + costDetailDomains.size() + " 项");
            costDao.update(costDomain);
        }
    }

    @Override
    public Integer setStatus(String costNo, int i) {
        CostDomain costDomain = new CostDomain();
        costDomain.setCostNo(costNo);
        costDomain.setCostStatus(i);
        return costDao.update(costDomain);
    }

    @Override
    public Integer updateById(CostDomain costDomain) {
        return costDao.updateById(costDomain);
    }


    @Override
    public void updateCashierAnnex(String costNo, String filePath, String downloadUrl) {
        costDao.updateCashierAnnex(costNo, filePath, downloadUrl);
    }

    @Override
    public List<CostListPrintDto> printList(List<String> printNos) {
        return printNos.stream().map(this::printDto).collect(Collectors.toList());
    }




    @Transactional
    @Override
    public void departmentCheck(String costNo, Integer currentUserId) {
        CostDomain costDomain = costDao.selectByCostNo(costNo);
        CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());
        //需要自动审核
        if (costTemplate.shouldDepartmentAutoCheck()) {
            //自动审核通过
            if (this.autoCheck(costDomain)) {
                costDomain.setCostStatus(CostDomain.STATUS_FINANCIAL_CHECK);
                costDao.updateById(costDomain);
                //流转状态
                costSubscribe.subscribe(costDomain);
                costLogService.save(costNo, currentUserId, "部门自动审核通过", CostLogDomain.AUTO_CHECK);
            }
            //自动审核失败
            else {
                //人工审核
                this.departmentManualCheck(costNo, currentUserId);
            }
        }
        //人工审核
        else {
            //人工审核
            this.departmentManualCheck(costNo, currentUserId);
        }
    }




    @Transactional
    @Override
    public void financialCheck(String costNo, Integer currentUserId) {
        CostDomain costDomain = costDao.selectByCostNo(costNo);
        CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());

        //需要自动审核
        if (costTemplate.shouldFinalAutoCheck()) {
            //自动审核通过
            if (this.autoCheck(costDomain)) {
                costDomain.setCostStatus(CostDomain.STATUS_FINAL_CHECK);
                costDao.updateById(costDomain);
                //流转状态
                costSubscribe.subscribe(costDomain);
                costLogService.save(costNo, currentUserId, "财务自动审核通过", CostLogDomain.AUTO_CHECK);
            }
            //自动审核失败
            else {
                //人工审核
                this.financialManualCheck(costNo, currentUserId);
            }
        }
        //人工审核
        else {
            //人工审核
            this.financialManualCheck(costNo, currentUserId);
        }
    }

    protected void financialManualCheck(String costNo, Integer currentUserId) {

        CostDomain costDomain = costDao.selectByCostNo(costNo);
        CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());

        //人工审核通过
        if (costReviewerMapper.queryOne(costCompany.getId(), CostReviewer.financialReviewer, currentUserId) != null) {
            costDomain.setCostStatus(CostDomain.STATUS_FINAL_CHECK);
            costDao.updateById(costDomain);
            //流转状态
            costSubscribe.subscribe(costDomain);
            costLogService.save(costNo, currentUserId, "财务审核通过", CostLogDomain.MANUAL_CHECK);
        }
        //人工审核没权限
        else {
            throw new BizRuntimeException("current user no authority");
        }
    }


    @Transactional
    @Override
    public IPage<CostDto> checkCostList(Integer userid, Integer pageNum, Integer pageSize, Integer type) {
        IPage<CostDomain> page = new Page<>(pageNum, pageSize);
        LambdaQueryWrapper<CostDomain> wrapper = new LambdaQueryWrapper<>();
        UserDomain userDomain = userService.findByUserid(userid);
        //财务或者管理员
        if (userDomain.getIsadmin() != 0 || userDomain.getIsfinansys() != 0) {
            wrapper.in(CostDomain::getCompanyValue, Lists.newArrayList(userDomain.getAuthority().split(",")));
        } else {
            wrapper.eq(CostDomain::getCreateUserid, userid);
        }
        //财务 最终审核
        if (type == 1) {
            wrapper.in(CostDomain::getCostStatus, CostDomain.STATUS_FINAL_CHECK, CostDomain.STATUS_DEPARTMENT_CHECK);
        }
        //部门审核
        else if (type == 2) {
            wrapper.in(CostDomain::getCostStatus, CostDomain.STATUS_DEPARTMENT_CHECK);
        } else {
            log.warn("invalid type");
        }
        return costDao.selectPage(page, wrapper).convert(CostDomain::castToDto);
    }


    private CostListPrintDto printDto(String costNo) {
        CostListPrintDto print = new CostListPrintDto();
        CostDto cost = this.getCostByCostNo(costNo).castToDto();
        UserDomain user = userService.findByUserid(cost.getCreateUserid());
        if (user == null) {
            print.setDepartment("");
            print.setCreateUsername(cost.getCreateUsername() + "【注销】");
        } else {
            print.setDepartment(user.getDepartmentname1());
            print.setCreateUsername(cost.getCreateUsername());
        }
        print.setId(cost.getId());
        print.setCompanyName(cost.getCompanyName());
        print.setCostNo(costNo);
        print.setCreateTime(cost.getCreateTime());
        print.setBankCompany(cost.getBankCompany());
        print.setBankCardUser(cost.getBankCardUser());
        print.setBankCard(cost.getBankCard());
        print.setCostReason(cost.getCostReason());
        print.setDic(cost.getDicDto());
        print.setAmount(cost.getAmountDto());
        print.setTxtAmount(MoneyUtil.getCnNum(cost.getAmount()));
        if (1 == cost.getCostForm()) {
            // 付款单
            print.setCostFormStr("付");
            print.setBankCompanyStr("收款单位");
            print.setBankCardUserStr("收款户名");
            print.setFeeTypeStr("付款方式");
            print.setBankCardStr("收款账户");
            print.setCostReasonStr("付款理由");
            print.setCostReason(cost.getTypeName() + "/" + cost.getKindName() + ";  " + cost.getCostRemark());
            // 差额单的付款理由需详细说明
            if (null != cost.getIsLend() && 2 == cost.getIsLend()) {
                print.setCostReason("【差额单（关联借支单：" + cost.getSupCostNo() + "）】 " + cost.getTypeName() + "  " + cost.getCostRemark());
            }
            print.setCostAmountStr("付款金额");
        }
        if (2 == cost.getCostForm()) {
            // 收款单
            print.setCostFormStr("收");
            print.setBankCompanyStr("付款单位");
            print.setBankCardUserStr("付款户名");
            print.setFeeTypeStr("收款方式");
            print.setBankCardStr("付款账户");
            print.setCostReasonStr("收款理由");
            print.setCostAmountStr("收款金额");
        }

        if (3 == cost.getCostForm() && 1 == cost.getIsLend()) {
            // 借支单
            print.setCostFormStr("借支");
            print.setBankCompanyStr("收款单位");
            print.setBankCardUserStr("收款户名");
            print.setFeeTypeStr("付款方式");
            print.setBankCardStr("收款账户");
            print.setCostReasonStr("付款理由");
            print.setCostAmountStr("付款金额");
        }

        if (3 == cost.getCostForm() && 2 == cost.getIsLend()) {
            // 借还单
            print.setCostFormStr("借还");
            print.setBankCompanyStr("付款单位");
            print.setBankCardUserStr("付款户名");
            print.setFeeTypeStr("收款方式");
            print.setBankCardStr("付款账户");
            print.setCostReasonStr("收款理由");
            print.setCostAmountStr("收款金额");
            print.setDic(cost.getPayDicDto());
            print.setAmount(cost.getPayPlanAmountDto());
            print.setTxtAmount(MoneyUtil.getCnNum(cost.getPayPlanAmount()));
        }
        return print;
    }
}
