package com.blt.other;

import com.bailuntec.api.bailuntec.oa.OaApi;
import com.bailuntec.api.bailuntec.oa.response.OaDepartmentResp;
import com.bailuntec.api.bailuntec.oa.response.OaUserResp;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.model.OaDepartment;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.auth.service.IOaDepartmentService;
import com.blt.other.module.auth.service.IOaUserService;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.sys.dao.DepartmentReviewerMapper;
import com.blt.other.module.sys.model.CostReviewer;
import com.blt.other.module.sys.model.DepartmentReviewer;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Transactional
@RunWith(SpringRunner.class)
@SpringBootTest(classes = OtherApplication.class)
@ActiveProfiles("test")
public class OtherApplicationTests {

    @Autowired
    private OaApi oaApi;
    @Autowired
    private IOaUserService oaUserService;
    @Autowired
    private IOaDepartmentService oaDepartmentService;
    @Resource
    OaDepartmentMapper oaDepartmentMapper;
    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    DepartmentReviewerMapper departmentReviewerMapper;

    @Rollback
    @Test
    public void syncDepartmentReviewer() {
        departmentReviewerMapper.delete(new LambdaQueryWrapper<>());
        costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                .eq(CostReviewer::getType, CostReviewer.departmentReviewer));

        List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                .eq(CostReviewer::getType, 1));

        costReviewerList.stream().collect(Collectors.groupingBy(CostReviewer::getReferId))
                .forEach((departmentId, list) -> {

                    OaDepartment oaDepartment = oaDepartmentMapper.selectByDepartmentId(departmentId);
                    DepartmentReviewer departmentReviewer = new DepartmentReviewer();
                    departmentReviewer.setPrimaryDepartmentId(oaDepartment.getDepartmentId());
                    departmentReviewer.setAutoReviewAmount(oaDepartment.getDepartmentMinimumReviewAmount());
                    departmentReviewer.setPrimaryDepartmentName(oaDepartment.getName());

                    departmentReviewer.setSecondDepartmentId(0);
                    departmentReviewer.setSecondDepartmentName("全部");
                    departmentReviewer.setCreateTime(LocalDateTime.now());
                    departmentReviewer.setLastUpdateTime(LocalDateTime.now());

                    departmentReviewerMapper.insert(departmentReviewer);

                    list.forEach(costReviewer -> {
                        costReviewer.setReferId(departmentReviewer.getId());
                        costReviewer.setType(CostReviewer.departmentReviewer);
                        costReviewer.setId(null);
                        costReviewerMapper.insert(costReviewer);
                    });

                });
        costReviewerList.forEach(costReviewer -> {


        });
    }

    @Rollback(value = false)
    @Test
    public void syncOa() {
        List<OaUserResp> oaUserRespList = oaApi.getAllUser();
        List<OaDepartmentResp> oaDepartmentRespList = oaApi.getDeparmentList();

        List<OaUser> oaUserList = oaUserRespList.stream().map(oaUserResp -> {
            OaUser oaUser = new OaUser();
            oaUser.setCompanyId(oaUserResp.getCompanyId());
            oaUser.setDepartmentId(oaUserResp.getDepartmentId());
            oaUser.setOaUserId(oaUserResp.getId());
            oaUser.setUserAccount(oaUserResp.getUserAccount());
            oaUser.setUserCode(oaUserResp.getUserCode());
            oaUser.setUserName(oaUserResp.getUserName());
            return oaUser;
        })
                .collect(Collectors.toList());


        List<OaDepartment> oaDepartmentList = oaDepartmentRespList.stream().map(oaDepartmentResp -> {
            OaDepartment oaDepartment = new OaDepartment();
            oaDepartment.setCode(oaDepartmentResp.getCode());
            oaDepartment.setCompanyId(oaDepartmentResp.getCompanyId());
            oaDepartment.setManageUser1(oaDepartmentResp.getManageUser1());
            oaDepartment.setManageUser2(oaDepartmentResp.getManageUser2());
            oaDepartment.setName(oaDepartmentResp.getName());
            oaDepartment.setSort(oaDepartmentResp.getSort());
            oaDepartment.setParentId(oaDepartmentResp.getParentId());
            oaDepartment.setDepartmentId(oaDepartmentResp.getDepartmentId());
            oaDepartment.setFullName(oaDepartmentResp.getFullName());
            return oaDepartment;
        })
                .collect(Collectors.toList());

        Map<Integer, OaDepartment> oaDepartmentMap = oaDepartmentList.stream().collect(Collectors.toMap(
                OaDepartment::getDepartmentId, oaDepartment -> oaDepartment, (k1, k2) -> k1
        ));
        oaUserList.forEach(oaUser -> {
            oaUser.setPrimaryDepartmentId(this.getPrimaryDepartment(oaDepartmentMap, oaDepartmentMap.get(oaUser.getDepartmentId())).getDepartmentId());
            if (oaUserService.getOne(new LambdaQueryWrapper<OaUser>().eq(OaUser::getOaUserId, oaUser.getOaUserId())) == null) {
                oaUserService.save(oaUser);
            }
        });

        oaDepartmentList.forEach(oaDepartment -> {
            if (oaDepartmentMapper.selectByDepartmentId(oaDepartment.getDepartmentId()) == null) {
                oaDepartment.setUpdateUserId(0);
                oaDepartmentService.save(oaDepartment);
            } else {
                oaDepartmentService.update(oaDepartment, new LambdaQueryWrapper<OaDepartment>()
                        .eq(OaDepartment::getDepartmentId, oaDepartment.getDepartmentId()));
            }
        });

    }

    private OaDepartment getPrimaryDepartment(Map<Integer, OaDepartment> departmentMap, OaDepartment oaDepartment) {
        if (oaDepartment == null) {
            return new OaDepartment();
        }
        if (oaDepartment.getParentId().equals(0) || oaDepartment.getParentId() == null) {
            return oaDepartment;
        }
        return getPrimaryDepartment(departmentMap, departmentMap.get(oaDepartment.getParentId()));
    }
}

