package com.blt.other.module.database.model;

import com.bailuntec.common.SpringContextUtil;
import com.bailuntec.cost.api.dto.CostAttach;
import com.bailuntec.cost.api.dto.CostPlanDto;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.database.mapper.StatusMapper;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Accessors(chain = true)
@TableName(value = "cost_plan", autoResultMap = true)
@Data
public class CostPlanDomain implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id; // 费用单表 id

    @ApiModelProperty("费用计划编号")
    private String costPlanNo; // 费用计划编号

    @ApiModelProperty("主体编号")
    private String companyNo; // 主体编号
    @ApiModelProperty("主体名称")
    private String companyName; // 主体名称

    @ApiModelProperty("类型编号")
    private String typeNo; // 类型编号
    @ApiModelProperty("类型标题")
    private String typeName; // 类型标题
    @ApiModelProperty("种类编号")
    private String kindNo; // 种类编号
    @ApiModelProperty("费用计划编号")
    private String kindName; // 种类标题

    @ApiModelProperty("创建人id")
    private Integer createUserid; // 创建人 id
    @ApiModelProperty("创建人编号")
    private String createUsercode; // 创建人编号
    @ApiModelProperty("创建人名称")
    private String createUsername; // 创建人名称

    @ApiModelProperty("付款理由")
    private String costReason; // 付款理由
    @ApiModelProperty("费用单备注")
    private String costRemark; // 费用单备注

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime; // 创建时间

    @ApiModelProperty("关联子单")
    @Deprecated
    private String sonCostNo; // 关联子单

    @ApiModelProperty("关联父单")
    private String supCostNo; // 关联父单

    @ApiModelProperty("费用计划状态 0 待确认  1 已确认")
    private Integer costPlanStatus; // 费用计划状态 0 待确认  1 已确认

    @ApiModelProperty("文件地址")
    private String filePath; // 文件地址

    @ApiModelProperty("补充材料地址")
    private String morFilePath; // 补充材料地址

    @ApiModelProperty("费用总金额")
    private BigDecimal planAmount; // 费用总金额

    @ApiModelProperty("二级物流供应商ID")
    private Integer subLogisticsSupplierId; // 二级物流供应商ID
    @ApiModelProperty("一级物流供应商ID")
    private Integer logisticsSupplierId; // 一级物流供应商ID

    @ApiModelProperty("收款银行（平台）")
    private String bankName; // 收款银行（平台）
    @ApiModelProperty("收款账户")
    private String bankCard; // 收款账户
    @ApiModelProperty("收款用户名")
    private String bankCardUser; // 收款用户名
    @ApiModelProperty("收款/付款单位")
    private String bankCompany; // 收款/付款单位

    @ApiModelProperty("补充信息")
    private String morRemark; // 补充信息

    @ApiModelProperty("1 付款费用 2 收款费用 3 借支/借还")
    private Integer costForm; // 1 付款费用 2 收款费用 3 借支/借还
    @ApiModelProperty("1 借支 2 借还")
    private Integer isLend; // 1 借支 2 借还

    @ApiModelProperty("借支单已还金额")
    private BigDecimal hadPay; // 借支单已还金额
    @ApiModelProperty("借支单状态 1 未还 2 部分还款  3 结清")
    private Integer lendStatus; // 借支单状态 1 未还 2 部分还款  3 结清
    @ApiModelProperty("借支单补偿金额")
    private BigDecimal compensate; // 借支单补偿金额
    @ApiModelProperty("冲销金额")
    private BigDecimal counteract; // 冲销金额
    @ApiModelProperty("借还单余额")
    private BigDecimal lendBalance; // 借还单余额
    @ApiModelProperty("驳回原因")
    private String rejectReason; // 驳回原因
    @ApiModelProperty("币种")
    private String dic; // 币种
    @ApiModelProperty("借还单冲销金额 ( 支付币种 )")
    private BigDecimal payCounteract; // 借还单冲销金额 ( 支付币种 )
    @ApiModelProperty("借还单余额 （ 支付币种 ）")
    private BigDecimal payLendBalance; // 借还单余额 （ 支付币种 ）
    @ApiModelProperty("计划金额 （ 支付币种 ）")
    private BigDecimal payPlanAmount; // 计划金额 （ 支付币种 ）
    @ApiModelProperty("支付币种")
    private String payDic; // 支付币种
    @ApiModelProperty("汇率")
    private BigDecimal payCur; // 汇率

    @TableField(exist = false)
    @ApiModelProperty("费用计划编汇率号")
    private BigDecimal cur; // 汇率

    @ApiModelProperty("0 不抵扣个税  1 抵扣个税")
    private Integer isTax; // 0 不抵扣个税  1 抵扣个税
    @ApiModelProperty("公司主体value")
    private Integer companyValue; // 公司主体value

    @TableField(value = "`attach`", typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty("附加字段")
    private List<CostAttach> attach;

    @ApiModelProperty("费用模版id")
    private Integer costTemplateId;

    @TableField(exist = false)
    private CostTemplate costTemplate;

    public CostPlanDto castToDto() {
        StatusMapper statusMapper = SpringContextUtil.getBean(StatusMapper.class);

        CostPlanDto costPlanDto = new CostPlanDto();
        BeanUtils.copyProperties(this, costPlanDto);
        costPlanDto.setCostFormDto(statusMapper.getStatusValue("cost_form", costPlanDto.getCostForm()));
        costPlanDto.setIsLendDto(statusMapper.getStatusValue("is_lend", costPlanDto.getIsLend()));
        costPlanDto.setCostPlanStatusDto(statusMapper.getStatusValue("cost_plan_status", costPlanDto.getCostPlanStatus()));
        if (1 == costPlanDto.getCostForm()) {
            costPlanDto.setIsTaxStr(statusMapper.getStatusValue("is_tax", costPlanDto.getIsTax()));
        } else {
            costPlanDto.setIsTaxStr("");
        }
        return costPlanDto;
    }
}
