package com.blt.other.module.cost.service.impl.costcheck;

import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.auth.model.CostReviewer;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.database.model.CostLogDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/30 2:57 下午
 */
@Component
public class DepartmentCheckState extends CostState {

    @Autowired
    FinancialCheckState financialCheckState;

    @Override
    public void handle() {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;
        CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_DEPARTMENT_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //如果是默认模版 不需要部门审核
        if (costTemplate.getIsDefault()) {
            //流转状态
            nextState(financialCheckState);
            costSubscribe.subscribe(costContext);
        }

        //需要自动审核
        if (costTemplate.shouldDepartmentAutoCheck()) {
            //自动审核通过
            if (autoCheck(costDomain)) {
                costDomain.setCostStatus(CostDomain.STATUS_FINANCIAL_CHECK);
                costDao.updateById(costDomain);
                costLogService.save(costDomain.getCostNo(), currentUserId, "部门自动审核通过", CostLogDomain.DEPARTMENT_AUTO_PASS);

                //流转状态
                nextState(financialCheckState);
                costSubscribe.subscribe(costContext);
                return;
            }
        }

        //人工审核
        OaUser costUser = oaUserMapper.selectByOaUserId(costDomain.getCreateUserid());

        //人工审核通过
        if (costReviewerMapper.queryOne(costUser.getPrimaryDepartmentId(), CostReviewer.departmentReviewer, currentUserId) != null) {
            costDomain.setCostStatus(CostDomain.STATUS_FINANCIAL_CHECK);
            costDao.updateById(costDomain);
            costLogService.save(costDomain.getCostNo(), currentUserId, "部门审核通过", CostLogDomain.DEPARTMENT_AUTO_PASS);

            nextState(financialCheckState);
            //发布到总线尝试下个环节的自动审核
            costSubscribe.subscribe(costContext);
        }
        //人工审核没权限
        else {
            throw new BizRuntimeException("current user no authority");
        }
    }


    @Override
    public void refuse() {

    }
}
