package com.blt.other.module.cost.service.impl.costcheck;

import com.blt.other.module.auth.dao.CostReviewerMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.cost.service.CostLogService;
import com.blt.other.module.cost.service.ICostTemplateService;
import com.blt.other.module.cost.service.impl.cost.CostSubscribe;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/30 2:18 下午
 */

public abstract class CostState {


    @Autowired
    CostDao costDao;
    @Autowired
    CostLogService costLogService;
    @Autowired
    ICostTemplateService costTemplateService;
    @Autowired
    OaUserMapper oaUserMapper;
    @Autowired
    CostReviewerMapper costReviewerMapper;
    @Autowired
    CostSubscribe costSubscribe;


    //0 待提交 1- 待财务审核 2待出纳付款 3被驳回 4已支付 5已作废  6-待部门审核 7-待财务审核 8-待最终审核人审核
    protected CostContext costContext;

    /**
     * 是否通过所有模版自动校验
     *
     * @param costDomain ost
     * @return res
     */
    boolean autoCheck(CostDomain costDomain) {
        CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());

        //是否通过所有模版自动校验
        List<Boolean> ruleChecks = costTemplate.getCostTemplateColList()
                .stream()
                .map(costTemplateCol -> costTemplateCol.ruleCheck(costDomain))
                .collect(Collectors.toList());

        return !ruleChecks.contains(false);
    }


    public CostContext getCostContext() {
        return costContext;
    }

    public void setCostContext(CostContext costContext) {
        this.costContext = costContext;
    }


    void nextState(CostState costState) {
        //清空审核上下文的审核人
        costContext.currentUserId = null;
        //并且流转到下一个状态
        costContext.setCostState(costState);
    }


    public abstract void handle();

    public abstract void refuse();
}
