package com.blt.other.module.auth.service.impl;

import com.bailuntec.common.JsonUtilByFsJson;
import com.blt.other.module.auth.service.GetDeparmentListService;
import com.blt.other.module.auth.vo.DepartmentMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;

@Service
public class GetDeparmentListServiceImpl implements GetDeparmentListService {

    Logger logger = LoggerFactory.getLogger(GetDeparmentListServiceImpl.class);

    @Autowired
    private RestTemplate restTemplate;

    @Value("${url.api.GetDeparmentListApi}")
    private String getDeparmentListApi;

    @Override
    public List<DepartmentMsg> getList() {
        String response = restTemplate.getForEntity(getDeparmentListApi, String.class).getBody();
        return JsonUtilByFsJson.jsonToList(response, DepartmentMsg.class);
    }

    @Override
    public DepartmentMsg getDeparment(String deparmentName) {
        List<DepartmentMsg> list = getList();
        if (null != list && list.size() >= 1) {
            for (DepartmentMsg departmentMsg : list) {
                if (null != deparmentName && (deparmentName.toLowerCase()).equals((departmentMsg.getName()).toLowerCase())) {
                    return departmentMsg;
                }
            }
        }
        return null;
    }


}
