package com.blt.other.module.sys.controller;


import com.bailuntec.cost.api.response.CostResult;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.blt.other.module.sys.dto.request.AddDepartmentReviewerReq;
import com.blt.other.module.sys.dto.request.DepartmentReviewerListReq;
import com.blt.other.module.sys.dto.request.ModifyDepartmentReviewerReq;
import com.blt.other.module.sys.dto.request.RemoveDepartmentReviewerReq;
import com.blt.other.module.sys.dto.response.DepartmentReviewerListItem;
import com.blt.other.module.sys.service.IDepartmentReviewerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * <p>
 * 部门审核人 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-12-21
 */
@Api(tags = "部门审核配置")
@RestController
@RequestMapping("/departmentReviewer")
public class DepartmentReviewerController {

    @Resource
    IDepartmentReviewerService departmentReviewerService;

    @ApiOperation("获取部门审核人配置列表")
    @PostMapping("/departmentReviewerList")
    public CostResult<IPage<DepartmentReviewerListItem>> departmentReviewerList(@RequestBody DepartmentReviewerListReq req) {
        IPage<DepartmentReviewerListItem> oaDepartmentIPage = departmentReviewerService.departmentReviewerList(req);
        return CostResult.success(oaDepartmentIPage);
    }

    @ApiOperation("/修改部门审核人")
    @PostMapping("/modifyDepartmentReviewer")
    public CostResult<Void> modifyDepartmentReviewer(@RequestBody ModifyDepartmentReviewerReq req) {
        departmentReviewerService.modifyDepartmentReviewer(req);
        return CostResult.success();
    }

    @ApiOperation("新增部门审核人")
    @PostMapping("/addDepartmentReviewer")
    public CostResult<Void> addDepartmentReviewer(@RequestBody AddDepartmentReviewerReq req) {
        departmentReviewerService.addDepartmentReviewer(req);
        return CostResult.success();
    }

    @ApiOperation("删除部门审核人")
    @PostMapping("/removeDepartmentReviewer")
    public CostResult<Void> removeDepartmentReviewer(@RequestBody RemoveDepartmentReviewerReq req) {
        departmentReviewerService.removeDepartmentReviewer(req);
        return CostResult.success();
    }

}
