package com.blt.other.module.auth.controller;


import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.module.auth.model.OaDepartment;
import com.blt.other.module.auth.service.IOaDepartmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
@Api(tags = "oa公司部门接口")
@RestController
@RequestMapping("/oaDepartment")
public class OaDepartmentController {

    @Resource
    IOaDepartmentService oaDepartmentService;

    @ApiOperation("获取百伦公司主体下面的一级部门列表")
    @GetMapping("/primaryDepartment")
    public CostResult<List<OaDepartment>> oaDepartment(@RequestParam Integer companyId) {
        List<OaDepartment> oaDepartmentList = oaDepartmentService.oaDepartment(companyId);
        return CostResult.success(oaDepartmentList);
    }

    @ApiOperation("更新部门审核金额")
    @GetMapping("/updateDepartmentMinimumReviewAmount")
    public CostResult<Void> updateDepartmentMinimumReviewAmount(@RequestParam Integer oaDepartmentId,
                                                                @RequestParam BigDecimal amount) {
        oaDepartmentService.updateDepartmentMinimumReviewAmount(oaDepartmentId, amount);
        return CostResult.success();
    }
}
