package com.blt.other;

import com.bailuntec.api.bailuntec.oa.OaApi;
import com.bailuntec.api.bailuntec.oa.response.OaDepartmentResp;
import com.bailuntec.api.bailuntec.oa.response.OaUserResp;
import com.blt.other.auth.model.OaDepartment;
import com.blt.other.auth.model.OaUser;
import com.blt.other.auth.service.IOaDepartmentService;
import com.blt.other.auth.service.IOaUserService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@RunWith(SpringRunner.class)
@SpringBootTest(classes = OtherApplication.class)
@ActiveProfiles("test")
public class OtherApplicationTests {

    @Autowired
    private OaApi oaApi;
    @Autowired
    private IOaUserService oaUserService;
    @Autowired
    private IOaDepartmentService oaDepartmentService;

//    @Transactional(rollbackFor = Exception.class)
    @Test
    public void syncOa() {
        List<OaUserResp> oaUserRespList = oaApi.getAllUser();
        List<OaDepartmentResp> oaDepartmentRespList = oaApi.getDeparmentList();

        List<OaUser> oaUserList = oaUserRespList.stream().map(oaUserResp -> {
            OaUser oaUser = new OaUser();
            oaUser.setCompanyId(oaUserResp.getCompanyId());
            oaUser.setDepartmentId(oaUserResp.getDepartmentId());
            oaUser.setOaUserId(oaUserResp.getId());
            oaUser.setUserAccount(oaUserResp.getUserAccount());
            oaUser.setUserCode(oaUserResp.getUserCode());
            oaUser.setUserName(oaUserResp.getUserName());
            return oaUser;
        })
                .collect(Collectors.toList());


        List<OaDepartment> oaDepartmentList = oaDepartmentRespList.stream().map(oaDepartmentResp -> {
            OaDepartment oaDepartment = new OaDepartment();
            oaDepartment.setCode(oaDepartmentResp.getCode());
            oaDepartment.setCompanyId(oaDepartmentResp.getCompanyId());
            oaDepartment.setManageUser1(oaDepartmentResp.getManageUser1());
            oaDepartment.setManageUser2(oaDepartmentResp.getManageUser2());
            oaDepartment.setName(oaDepartmentResp.getName());
            oaDepartment.setSort(oaDepartmentResp.getSort());
            oaDepartment.setParentId(oaDepartmentResp.getParentId());
            oaDepartment.setDepartmentId(oaDepartmentResp.getDepartmentId());

            return oaDepartment;
        })
                .collect(Collectors.toList());

        Map<Integer, OaDepartment> oaDepartmentMap = oaDepartmentList.stream().collect(Collectors.toMap(
                OaDepartment::getDepartmentId, oaDepartment -> oaDepartment, (k1, k2) -> k1
        ));
        oaUserList.forEach(oaUser ->
                oaUser.setPrimaryDepartmentId(this.getPrimaryDepartment(oaDepartmentMap, oaDepartmentMap.get(oaUser.getDepartmentId())).getDepartmentId()));

        oaUserService.saveBatch(oaUserList);
        oaDepartmentService.saveBatch(oaDepartmentList);


    }

    private OaDepartment getPrimaryDepartment(Map<Integer, OaDepartment> departmentMap, OaDepartment oaDepartment) {
        if (oaDepartment == null) {
            return new OaDepartment();
        }
        if (oaDepartment.getParentId().equals(0) || oaDepartment.getParentId() == null) {
            return oaDepartment;
        }
        return getPrimaryDepartment(departmentMap, departmentMap.get(oaDepartment.getParentId()));
    }
}

