package com.blt.other.supplier.service;

import com.blt.other.database.model.SupplierDomain;

import java.util.List;
import java.util.Map;

public interface SupplierService {

    /**
     * 通过 supplierid 获取供应商信息
     * @param supplierid
     * @return
     */
    SupplierDomain getSupplierByid(Integer supplierid);

    /**
     * 分页获取供应商列表
     * @return
     */
    Map<String,Object> getAllSupplier(Integer page,Integer pageSize);

    /**
     * 新增供应商
     * @param supplierDomain
     * @return
     */
    Integer saveSupplier(SupplierDomain supplierDomain);

    /**
     * 根据 name 和 skuTypeNo 获取供应商信息
     * @param name
     * @param skuTypeNo
     * @return
     */
    List<SupplierDomain> getByNameAndSkuTypeNo(String name,String skuTypeNo);

    /**
     * 获取所有供应商
     * @return
     */
    Map<String,Object> getAllSuppliers();

    /**
     * 根据 supplierNo 获取供应商
     * @param supplierNo
     * @return
     */
    SupplierDomain getSupplierByNo(String supplierNo);

    /**
     * 根据 sku 大类获取供应商列表
     * @param skuTypeNo
     * @return
     */
    List<SupplierDomain> getSupplierBySkuTypeNo(String skuTypeNo);

    Integer deleteSup(String supplierNo);

    Integer update(SupplierDomain supplier);
}
