package com.blt.other.cost.service;

import com.bailuntec.cost.api.dto.CostDto;
import com.blt.other.cost.vo.CostCheckSearchKeysVo;
import com.blt.other.database.model.CostDomain;

import java.util.List;
import java.util.Map;

public interface CostCheckSearchService {

    Map<String,Object> getAll(Integer pageNum,Integer pageSize, String authority);

    String findAuthorityByUserid(Integer userId);

    /**
     * 通过关键字模糊查询
     * @param key
     * @return
     */
    Map<String,Object> seachByKey(String key,int pageNum,int pageSize, String authority);

    List<CostDto> domainListToDto(List<CostDomain> domains);

    /**
     * 多条件筛选
     * @param searchKeysVo
     * @return
     */
    Map<String,Object> searchByKeys(CostCheckSearchKeysVo searchKeysVo);

    List<CostDomain> getLinkCost();
}
