package com.blt.other.cost.dao;

import com.blt.other.cost.vo.CostCheckSearchKeysVo;
import com.blt.other.database.model.CostDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface CostCheckSearchDao {

    /**
     * 通过关键字模糊查询
     * @param key
     * @return
     */
    List<CostDomain> selectByKey(@Param("key") String key, @Param("authority") String authority);

    List<CostDomain> selectByKeys(CostCheckSearchKeysVo searchKeysVo);

    List<CostDomain> selectAll(@Param("authority") String authority);

    String findAuthorityByUserid(int parseInt);

    List<CostDomain> selectLinkList();

}
